import java.awt.Toolkit;      // abstract, direct access to platform-specific resources.

import java.awt.Image;        // abstract class,

                              // for referencing (native) image-code (JPEG, GIF).

import java.awt.Graphics;     // abstract class, references native code to draw on-screen.

import javax.swing.JComponent;// abstract class,

                   // anonymously extended to a class, instantiating a DRAWING-SURFACE.

import javax.swing.JFrame;    // non-abstract class,

                  // DESKTOP-WINDOW containing the drawing-surface for display.



/* Identifiers of the class-types given by the first three abstract classes

   have access to native code or data.

   The fourth abstract class is anonymously extended and

   anonymously instantiated in the code below.

*/



class ViewImage

{

  public static void main( String imageFileName[] )

  { String fileName = imageFileName[0];

// ------------------------------------------------- read image from current directory

    final Image anImage = Toolkit.getDefaultToolkit().getImage( fileName );

    System.out.println( "Image reference: " + anImage );

// --------------------------------------------------------------------- display image

    JFrame screenArea = new JFrame( fileName );

    screenArea.getContentPane().add

    ( new JComponent()

      {   // ^ drawing-surface: given as anonymous class and as anonymous object

        public void paintComponent( Graphics drawingTools )

        { drawingTools.drawImage( anImage, 0, 0, this );

      } }

    );

    screenArea.setSize(200,200);

    screenArea.setVisible(true);

} }





/*
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% javac ViewImage.java
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% java ViewImage TestImage.jpg
Image reference: com.apple.mrj.internal.awt.VImage@4d8669 source = sun.awt.image.FileImageSource@337838
^C (Ctrl-C in terminal-window)
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > javac ViewImage.java
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > java ViewImage TestImage.jpg
Image reference: sun.awt.motif.X11Image@133796
(Ctrl-C in terminal-window)
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput >
*/

/*
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>javac ViewImage.java

C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>java ViewImage TestImage.jpg
Image reference: sun.awt.windows.WImage@50bd4d
(Ctrl-C in DOS-window)
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






