import javax.swing.JFrame; // or JWindow, JApplet, JDialog, JInternalFrame

import javax.swing.JRootPane;

import java.awt.Component; // for glassPane

import java.awt.Container; // for ContentPane

import java.awt.Color;

import javax.swing.JLabel; // stands for any component

import javax.swing.JMenuBar;

import javax.swing.JMenu;

import javax.swing.JMenuItem;

import javax.swing.JLayeredPane;

import javax.swing.JPanel;



class SwingRootPane // ComponentContainers in Swing

{

public static void main( String unused[] )

{ JFrame aFrame = new JFrame("RootPane");



// ------------------------------------------------------------- glass-pane: top level ---

  Component glassPane = aFrame.getGlassPane();

/* ready to take components like popup-menus or toolbars, even a LayoutManager,

   drawings (paint()) or event-objects (add...Listener)

*/

  JPanel cGlassPane = (JPanel)glassPane;

  cGlassPane.add( new TestComponent("drawn on the glass pane", Color.blue ) );

  cGlassPane.setVisible(true);                              //  = new Color(0,0,255) RGB



// ======================================= layered-pane: access to intermediate levels ===

  JLayeredPane paneStack = aFrame.getLayeredPane();

  JLabel upperComponent = new TestComponent("UpperLayer", new Color(100,100,255) );

  upperComponent.setBounds(50,35,100,30);

        // in pixels: location-horizontal, location-vertical, length, height

  JLabel lowerComponent = new TestComponent("LowerLayer", new Color(200,200,255) );

  lowerComponent.setBounds(45,15,100,30);

  paneStack.add( lowerComponent, JLayeredPane.DEFAULT_LAYER );

  paneStack.add( upperComponent, JLayeredPane.DRAG_LAYER );

// paneStack.setVisible(true); not needed



// ____________________________________________________base-pane: frame content layer ___

  JRootPane rootPane = aFrame.getRootPane();

  JMenuItem item = new JMenuItem("one");

  JMenu menu = new JMenu("MicroMenu");

  JMenuBar aBar = new JMenuBar();

  menu.add( item );

  aBar.add( menu );

  rootPane.setJMenuBar( aBar );

  Container aContentPane = aFrame.getContentPane();

  aContentPane.add( new TestComponent("some component", new Color(240,240,255) ) );



  aFrame.setSize(300,120);

  aFrame.setVisible(true);

} }



class TestComponent extends JLabel

{ TestComponent( String text )

  { this( text, null ); }

  TestComponent( String text, java.awt.Color color)

  { super( text );

    if( color != null )

    { setOpaque( true );

      setBackground( color ); // contrary to foreground, the letters of the text

} } }









/*
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% javac SwingRootPane.java
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% java SwingRootPane
^C (Ctrl-C in terminal-window)
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > javac SwingRootPane.java
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > java SwingRootPane
(Ctrl-C in terminal-window)
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput >
*/

/*
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>javac SwingRootPane.java

C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>java SwingRootPane
(Ctrl-C in DOS-window)
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






