import java.awt.GraphicsEnvironment;

import java.awt.Container;

import java.awt.GridLayout;

import javax.swing.JComponent;

import javax.swing.JFrame;

import javax.swing.JLabel;

import java.awt.Font;

class PlatformFontViewer extends JFrame

{

  public static void main( String unused[] )

  { new PlatformFontViewer();

  }

  PlatformFontViewer()

  { super("Some Installed Fonts");

    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();

    String [] fontList = ge.getAvailableFontFamilyNames();

    int selection;

    if( fontList.length > 20 ) selection = 20;

    else selection = fontList.length;

    Container showPane = this.getContentPane();

    showPane.setLayout( new GridLayout( selection , 2 ));

    JComponent textComponent [] = new JComponent [ selection ];

    for( int i = 0; i < selection; i++ )

    { System.out.println( fontList[i] );

      showPane.add( new JLabel( fontList[i] ) );

      textComponent[i] = new JLabel( fontList[i] );

// textComponent[i].setFont( Font.getFont( fontList[i] ) ); // does not work

      textComponent[i].setFont( new Font( fontList[i], Font.PLAIN, 16 ) );

      showPane.add( textComponent[i] );

    }

    //pack()

    setSize(200,200);

    setVisible(true);

} }








/*
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% javac PlatformFontViewer.java
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% java PlatformFontViewer
#Gungseoche Regular
#Pilgiche Regular
.Aqua Kana
.Aqua Kana Bold
.Devanagari MT X
.Devanagari MT X Bold
.Gujarati MT X
.Gujarati MT X Bold
.Keyboard
Al Bayan Bold
Al Bayan Plain
American Typewriter Bold
American Typewriter Condensed
American Typewriter Condensed Bold
American Typewriter Condensed Light
American Typewriter Light
American Typewriter Regular
Andale Mono
Apple Chancery
Apple LiGothic Medium
^C (Ctrl-C)
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% 
*/

/*
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > javac PlatformFontViewer.java
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > java PlatformFontViewer
Bitstream Charter
BookmanL
CenturySchoolbookL
ChanceryL
Courier
Courier 10 Pitch
Cursor
Default
Dialog
DialogInput
Dingbats
GothicL
Lucida Bright
Lucida Sans
Lucida Sans Typewriter
LuciduxMono
LuciduxSans
LuciduxSerif
Monospaced
NimbusMonoL
(Ctrl-C)
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput >
*/

/*
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>javac PlatformFontViewer.java

C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>java PlatformFontViewer
Arial
Arial Black
Comic Sans MS
Courier New
Default
Dialog
DialogInput
Impact
Lucida Console
Lucida Sans
Marlett
Monospaced
SansSerif
Serif
Symbol
Tahoma
Times New Roman
Verdana
Webdings
Wingdings
(Ctrl-C)
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>
*/




/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






