import javax.swing.JComponent;

import javax.swing.JWindow;

import javax.swing.JList;

import javax.swing.JScrollPane;

import javax.swing.event.ListSelectionListener; // interface,

                      // signaling the implementation of a valueChanged()-method.

import javax.swing.event.ListSelectionEvent;



class ListDemo extends JWindow

{

  public static void main( String data[] )

  {

    if( data.length == 0 ) data = new String[]{ "0", "1", "2" };

    JList aList = new JList( data );

    aList.addListSelectionListener( new SomeListSelectionListener() );

    JScrollPane aScrollPane = new JScrollPane( aList );

    new ListDemo( aScrollPane );

  }

  ListDemo( JComponent display )

  {

    getContentPane().add( display );

    setSize( 200, 100 );

    setVisible( true );

} }



class SomeListSelectionListener implements ListSelectionListener

{

  public void valueChanged( ListSelectionEvent e )

  { if( e.getValueIsAdjusting() == false ) return; // nothing new

    Object[] selected = ( (JList)e.getSource() ).getSelectedValues();

    for( int i = 0; i < selected.length; i++ ) System.out.println( selected[i] );

} }







/*
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% javac ListDemo.java
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% java ListDemo
^C (Ctrl-C in terminal-window)
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > javac ListDemo.java
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > java ListDemo ONE TWO THREE
THREE
TWO
(Ctrl-C in terminal-window)
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput >
*/

/*
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>javac ListDemo.java

C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>java ListDemo UN DEUX TROIS
DEUX
UN
(Ctrl-C in DOS-window)
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






