import java.awt.Graphics;                  // toolbox for drawing.

import java.awt.Image;                    // abstract class gives references to images.

import java.awt.image.MemoryImageSource; // an ImageProducer,

                                        // produces an image from a given integer-array.

import javax.swing.JComponent;         // used as drawing surface.

import javax.swing.JFrame;            // furnishes screen area.



class HelloBitmapARGB

{

  public static void main( String unused[] )

  { final int width = 200,   // final because createPixelArray() requires it,

              height = 200,  // otherwise another thread may

              firstPixel = 0,// change values during computation.

              line = width;  // number of pixels per horizontal line

    final int [] pixelArray;

// ---------------------------------------------------------- production of byte-array

              pixelArray = createPixelArray( width, height ); // defined below

// ------------------------------------------------------------------- drawing-surface

    JComponent drawingSurface = new JComponent()

    { Image image;    // line above: anonymous class - non-anonymous object

      {                                               // non-static initializer

        image =

this.createImage( new MemoryImageSource( width, height, pixelArray, firstPixel, line ) );

      }

      public void paintComponent( Graphics tools )// or paint() with java.awt.Component

      { tools.drawImage( image, 0, 0, null );

      }

    };

// ----------------------------------------------------------------- drawing on-screen

    JFrame screenArea = new JFrame( "Title" );

    screenArea.getContentPane().add( drawingSurface );

    screenArea.setSize(200,200);

    screenArea.setVisible(true);

  }



// ---------------------------------------------------------- production of byte-array

  static int [] createPixelArray( int width, int height )

  { int pixelArrayLength = width * height;

    int [] pixelArray = new int[ pixelArrayLength ];

    int blue, green, red, alpha, x, y, value, div = width * width + height * height;

    for( int i = 0; i < pixelArrayLength; i++ )

    { x = i % width;      // x-coordinate of pixel = remainder when lines subtracted

      y = i / width;      // y-coordinate of pixel = number of lines

      value = (int)(255 * java.lang.Math.sin( java.lang.Math.PI * (x*x + y*y) / div ));

      red = value;        // a red ring

      green = 0;          // no green

      alpha = value;      // 0 = image completely transparent, only background visible

                          // 255 = only image, no background

      blue = 255-value;   // ring gets blue by the amount of vanishing red.



/* The amounts of alpha and red are chosen to change according to the value-function,

   then the color-information is coded into an integer-value

   and stored in the array of pixels:

*/

      pixelArray[i] = Transform.intFromBytes(blue, green, red, alpha);

          // for the 'Transform' utility-class, see below

    }

    return pixelArray;

} }





class Transform

// uses int-variable to store an array of four unsigned byte-values (used by ARGB color model)

{

  static int intFromBytes( int one, int two, int three, int four ) // int range 0..255

  { int [] handover = {one,two,three,four};

    // since array-constants can be used only in initializers

    return intFromBytes(handover);

  }

  static int intFromBytes( int [] b ) // that's b[0],b[1],... least significant first

// the work is done in the return clause the rest are machinations to avoid errors

  { int [] intArray = new int[4];

    boolean smaller, larger, right;

    for( int i = 0; i < b.length; i++ )

    { smaller = b[i] < 0;

      larger  = b[i] > 255;

      right = !smaller & !larger;

      if(smaller) intArray[i] = 0;

      if(larger)  intArray[i] = 255;

      if(right)   intArray[i] = b[i];

    }

    return intArray[3] << 24 | intArray[2] << 16 | intArray[1] << 8 | intArray[0];

  }

  static int [] bytesFromInt( int n )

  { final int BIT_MASK = 255; // binary = 00000000 00000000 00000000 11111111

    int [] b = {0,0,0,0};     // cannot be written in one line return {(byte) n & BIT_MASK, ...};

    b[0] = n & BIT_MASK;      // extracts, then

                    // shifting (see page [BitwiseShiftOperators]) and extracting:

    b[1] = (n >>> 8) & BIT_MASK;

    b[2] = (n >>> 16) & BIT_MASK;

    b[3] = (n >>> 24) & BIT_MASK;

    return b;

} }






/*
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% javac HelloBitmapARGB.java
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% java HelloBitmapARGB
^C (Ctrl-C)
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > javac HelloBitmapARGB.java
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > java HelloBitmapARGB
(Ctrl-C)
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput >
*/

/*
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>javac HelloBitmapARGB.java

C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>java HelloBitmapARGB
(Ctrl-C)
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






