import java.awt.Graphics;          // abstract, method-calls are mapped onto native code

                                  //           for drawing on-screen.

import java.awt.Image;           // abstract class gives references to (native) image-code.

import java.awt.image.MemoryImageSource;// An ImageProducer,

                               //           produces an image from an integer-array.

import javax.swing.JComponent;// abstract, anonymously extended to a class,

                             //           instantiating a DRAWING-SURFACE.

import javax.swing.JFrame;  // DESKTOP-WINDOW containing the drawing-surface for display.



class HelloBitmap

{ public static void main( String unused[] )

  {

    final int width = 200,

              height = 200,

              firstPixel = 0,

              line = width; // number of pixels per horizontal line

    final int [] pixelArray;

/*  final because createPixelArray requires it,

    otherwise another thread may change values during computation.

*/

// ------------------------------------------------------------ production of byte-array

    pixelArray = createPixelArray( width, height ); // defined below

// --------------------------------------------------------------------- drawing-surface

    JComponent drawingSurface = new JComponent()    // inner class

    { Image image;

      {                                         // non-static initializer of inner class

        image =

this.createImage( new MemoryImageSource( width, height, pixelArray, firstPixel, line ) );

      }

      public void paintComponent( Graphics tools )  // or only paint()

      { tools.drawImage( image, 0, 0, null );

      }

    };

// ------------------------------------------------------------------- drawing on-screen

    JFrame screenArea = new JFrame( "Title" );

    screenArea.getContentPane().add( drawingSurface );

    screenArea.setSize(200,200);

    screenArea.setVisible(true);

  }



// ----------------------------------------------------------- production of byte-array

  static int [] createPixelArray( int width, int height )

  { int pixelArrayLength = width * height;

    int [] pixelArray = new int [ pixelArrayLength ];

    for( int i = 0; i < pixelArrayLength; i++ )

    {

      pixelArray[i] = (int)( (java.lang.Math.random() - 0.5) * 2 * 2147483647 );

    }                 // to cover the range of int-values randomly

    return pixelArray;

} }

 







/*
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% javac HelloBitmap.java
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway% java HelloBitmap
^C (Ctrl-C)
[localhost:~/JavaCodeFiles/SingleUserInterface/ScreenOutput] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > javac HelloBitmap.java
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput > java HelloBitmap
(Ctrl-C)
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/ScreenOutput >
*/

/*
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>javac HelloBitmap.java

C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>java HelloBitmap
(Ctrl-C)
C:\JavaCodeFiles\SingleUserInterface\ScreenOutput>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






