import javax.swing.JWindow;

import java.awt.Container; // for the Swing content-pane

import javax.swing.JPanel;

import javax.swing.JLabel;

import java.awt.event.MouseEvent;

import java.awt.event.MouseMotionListener;

import javax.swing.SwingUtilities;



public class SomeMousePad implements MouseMotionListener

{

  JLabel lblFixed, lblUpdated;

  JPanel textDisplay;

  MousePad mousePad;

  JWindow w;

  Container contentPane;

  public static void main( String unused[] ){ new SomeMousePad(); }  // --- main()-method

  SomeMousePad()                                                     // --- constructor

  {

    lblFixed = new JLabel( "mouse position:" );

    lblUpdated = new JLabel( "no focus yet" );

    textDisplay = new JPanel();

    textDisplay.setOpaque(true);

    textDisplay.setBackground( new java.awt.Color( 230, 230, 255 ) );

    textDisplay.add( lblFixed ); textDisplay.add( lblUpdated );

    mousePad = new MousePad();

    mousePad.setOpaque(true);

    mousePad.setBackground( new java.awt.Color( 230, 200, 255 ) );

    w = new JWindow();

    contentPane = w.getContentPane();

    contentPane.add( mousePad, "Center" );

    contentPane.add( textDisplay, "North" );

    w.setSize(500,100);

    mousePad.addMouseMotionListener( this );

    w.setVisible( true );

  }



  public void mouseMoved( MouseEvent e )                              // --- handler

  { /* System.out.println( "event dispatch thread? " +

                           SwingUtilities.isEventDispatchThread() );  */

    final MouseEvent f = e;

    lblUpdated.setText( f.getPoint().toString() );

    textDisplay.repaint();

    mousePad.updatePosition( f );

  }

  public void mouseDragged( MouseEvent e ){}                          // --- empty handler



  class MousePad extends JPanel // --------------------------------------- drawing surface

  { MousePad(){ super();}

    int x1, y1, x2, y2;

    void updatePosition( MouseEvent e )

    { x2 = x1; y2 = y1; x1 = e.getX(); y1 = e.getY();

      // w.repaint() // lets flicker the entire screen-component (1)

      // this.repaint(); // line follows mouse-pointer (2)

      this.repaint( Math.min(x1,x2), Math.min(y1,y2),

                    Math.abs(x1-x2)+1, Math.abs(y1-y2)+1 ); // (3)

      // above: only the relevant rectangles are redrawn,

      // thus only erasing lines when lines cross!

    }

    protected void paintComponent( java.awt.Graphics g )

    { super.paintComponent( g ); // paints background

      g.drawLine( x1, y1, x2, y2 );

} } }






/*
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway% javac SomeMousePad.java
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway% java SomeMousePad
^C (Ctrl-C)
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway%

marycosway@linux:~/JavaCodeFiles/SingleUserInterface/Interaction > javac SomeMousePad.java
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/Interaction > java SomeMousePad
(Ctrl-C)
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/Interaction >



C:\JavaCodeFiles\SingleUserInterface\Interaction>javac SomeMousePad.java

C:\JavaCodeFiles\SingleUserInterface\Interaction>java SomeMousePad
(Ctrl-C)
C:\JavaCodeFiles\SingleUserInterface\Interaction>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






