/*

--- Producer: References of class-type Image make it possible to get the name of the

    image-producer, by calling Image.getSource().

--- Consumer: Here hidden within the class JFrame.

--- Observer: The Display-class extends the javax.swing.JPanel-class,

    which extends the java.awt.Component-class. Therefore the Display-class

    implements the ImageObserver-interface and can override the imageUpdate()-method.

*/

import java.awt.Toolkit;   // direct access to platform-specific resources

import java.awt.Image;     // abstract class gives references to image-data

                           // (native or within JRE)

import java.awt.Graphics;  // a Java toolkit for graphical-objects ...

import javax.swing.JPanel; // used as drawing-surface

import javax.swing.JFrame; // screen-area for display

import javax.swing.JComponent;

import javax.swing.SwingUtilities;



class ImageViewerInfo extends JFrame

{

  public static void main( String fileNameOfImage[] )

  { String fileName = fileNameOfImage[0]; // read in image from current directory

    new ImageViewerInfo( fileName );

  }

  int beginWidth = 200, beginHeight = 50;

  Image theImage;

  ImageViewerInfo( String fileName )

  { super( fileName );

    theImage = Toolkit.getDefaultToolkit() .getImage( fileName );

    Display imageDisplay = new Display( theImage, this );

    getContentPane().add( imageDisplay, "Center" );

    getContentPane().add( new javax.swing.JLabel("Loading " + fileName), "South" );

    setSize( beginWidth, beginHeight );

    setVisible( true );

} }



class Display extends JPanel  // implements the interface java.awt.image.ImageObserver

{ Image image; ImageViewerInfo container;

  javax.swing.JLabel lbl;

  Display( Image img, ImageViewerInfo c)

  { image = img; container = c;

    lbl = new javax.swing.JLabel("Loading ... ");

    container.getContentPane().add( lbl, "North");

  }

  int areaCurrent = 0, areaGoal = 0, imageWidth = 1, imageHeight =1, count;

         // if all values above are 0, no image is loaded

  double percent = 0;

  //

  //

  /** This method does the actual painting

   */

  public void paintComponent( Graphics drawingTools )

  { drawingTools.drawImage( image, 0, 0, imageWidth, imageHeight, this ); // new thread

  } // container is ImageObserver

  //

  //

  /** This current object is of the interface-type ImageObserver,

      therefore the method imageUpdate() can be overridden

  */

  public boolean

  imageUpdate( java.awt.Image img, int bits, int x, int y, int width, int height )

  { // values of currently loaded rectangles of pixels

    System.out.println( "imageUpdate runs in event-dispatch-thread? " +

                        SwingUtilities.isEventDispatchThread() );

    if( (bits & HEIGHT) != 0)

    { System.out.println("Now available, height of base image = " + height + " pixel");

    }

    if( (bits & WIDTH) != 0)

    { System.out.println("Now available, width of base image = " + width + " pixel");

    }

    if( (bits & PROPERTIES) != 0)

    { System.out.println

      ( "Now the java.awt.Image.getProperty( PropertyName, ImageObserver )" +

        " returns non-trivial data to consumer: " +

        img.getProperty( "comment", container ).toString()

      );

    }

    if( (bits & SOMEBITS) != 0)

    { System.out.println

      ( "some pixels have been delivered, their range: " +

         new java.awt.Rectangle(x,y,width,height) );

      areaCurrent = areaCurrent + width * height;

      percent = Math.round( 10000*(double)areaCurrent / (double)areaGoal )/(double)100;

      System.out.println("Percent loaded: " + percent );

      lbl.setText("Loaded " + percent + " %");

      lbl.repaint(); return true;

    }

    if( (bits & ALLBITS) != 0)

    { System.out.println("Consumer received entire image, size: " + width + " " + height);

      container.setSize( width, height );

      imageWidth = width; imageHeight = height;

      container.validate();                     // no use for container.repaint();

      return false;

    }

    if( (bits & FRAMEBITS) != 0)

    { System.out.println

      ("Now available, " + (count++) + ". frame of a multiframe image.");

    }

    if( (bits & ABORT) != 0)

    { System.out.println("Producer-Consumer: automatic repeat ");

    }

    if( (bits & ERROR) != 0)

    { System.out.println("Producer-Consumer: error, no further tries"); return false;

    }

    // what to do further when notified by an consumer:

    // e.g. repaint(), notify user about loading status

    if(areaGoal == 0 && (bits & HEIGHT) != 0 && (bits & WIDTH) != 0)

    { areaGoal = img.getHeight(this) * img.getWidth(this);

    }

    return true; // further imageUpdate()-calls are needed

} }






/*
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway% javac ImageViewerInfo.java
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway% java ImageViewerInfo TestImage.jpg
imageUpdate runs in event-dispatch-thread? false
Now available, height of base image = 246 pixel
Now available, width of base image = 210 pixel
imageUpdate runs in event-dispatch-thread? false
Now the java.awt.Image.getProperty( PropertyName, ImageObserver ) returns nontrivial data to consumer: java.lang.Object@111f71
imageUpdate runs in event-dispatch-thread? false
some pixels have been delivered, their range: java.awt.Rectangle[x=0,y=0,width=210,height=1]
Percent loaded: 0.41
imageUpdate runs in event-dispatch-thread? false
some pixels have been delivered, their range: java.awt.Rectangle[x=0,y=1,width=210,height=1]
Percent loaded: 0.81
imageUpdate runs in event-dispatch-thread? false
......
some pixels have been delivered, their range: java.awt.Rectangle[x=0,y=244,width=210,height=1]
Percent loaded: 99.59
imageUpdate runs in event-dispatch-thread? false
some pixels have been delivered, their range: java.awt.Rectangle[x=0,y=245,width=210,height=1]
Percent loaded: 100.0
imageUpdate runs in event-dispatch-thread? false
Consumer received entire image, size: 210 246
^C
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway% java ImageViewerInfo TestImage.png
^C (png here still not supported, JRE blocks)
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway%
*/


/*
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/Interaction > java ImageViewerInfo TestImage.png
imageUpdate runs in event-dispatch-thread? false
Now available, height of base image = 246 pixel
Now available, width of base image = 210 pixel
imageUpdate runs in event-dispatch-thread? false
some pixels have been delivered, their range: java.awt.Rectangle[x=0,y=0,width=210,height=1]
Percent loaded: 0.41
imageUpdate runs in event-dispatch-thread? false
some pixels have been delivered, their range: java.awt.Rectangle[x=0,y=1,width=210,height=1]
Percent loaded: 0.81
...........
imageUpdate runs in event-dispatch-thread? false
some pixels have been delivered, their range: java.awt.Rectangle[x=0,y=244,width=210,height=1]
Percent loaded: 99.59
imageUpdate runs in event-dispatch-thread? false
some pixels have been delivered, their range: java.awt.Rectangle[x=0,y=245,width=210,height=1]
Percent loaded: 100.0
imageUpdate runs in event-dispatch-thread? false
Consumer received entire image, size: 210 246

marycosway@linux:~/JavaCodeFiles/SingleUserInterface/Interaction >
*/


/*
C:\JavaCodeFiles\SingleUserInterface\Interaction>javac ImageViewerInfo.java

C:\JavaCodeFiles\SingleUserInterface\Interaction>java ImageViewerInfo TestImage.png
imageUpdate runs in event-dispatch-thread? false
Now available, height of base image = 246 pixel
Now available, width of base image = 210 pixel
imageUpdate runs in event-dispatch-thread? false
some pixels have been delivered, their range: java.awt.Rectangle[x=0,y=0,width=210,height=1]
Percent loaded: 0.41
..............
Percent loaded: 99.19
imageUpdate runs in event-dispatch-thread? false
some pixels have been delivered, their range: java.awt.Rectangle[x=0,y=244,width
=210,height=1]
Percent loaded: 99.59
imageUpdate runs in event-dispatch-thread? false
some pixels have been delivered, their range: java.awt.Rectangle[x=0,y=245,width
=210,height=1]
Percent loaded: 100.0
imageUpdate runs in event-dispatch-thread? false
Consumer received entire image, size: 210 246

C:\JavaCodeFiles\SingleUserInterface\Interaction>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






