import javax.swing.JWindow;

import javax.swing.JDesktopPane;

import java.awt.event.KeyListener;

import java.awt.event.KeyEvent;

import java.awt.event.MouseListener;

import java.awt.event.MouseEvent;

import java.awt.event.ActionListener;

import java.awt.event.ActionEvent;

import javax.swing.JPopupMenu;

import javax.swing.JMenuItem;

import javax.swing.JInternalFrame;



class DesktopDemo

{

  public static void main( String unused[] )

  {

    JWindow window = new JWindow();  // JWindow is also a RootPaneContainer (interface)

    java.awt.Toolkit nativeTools = window.getToolkit();

    java.awt.Dimension dim = nativeTools.getScreenSize();

    window.setSize(dim);

    window.setLocation(0,0); // may be overridden by user-interface of OS (Linux)

    window.setVisible(true);



    JDesktopPane desktop = new JDesktopPane();

    System.out.println( desktop.getDesktopManager() );

    desktop.addMouseListener( new MouseClickListener() );

    window.setContentPane( desktop );

                        // an object of type JDesktopPane is also a JLayeredPane



                                          // JInternalFrame is a JComponent

    JInternalFrame ifr = new JInternalFrame( "InternalFrame", true, true, true, false );

                                          // title, resizable, closable, maximizable, iconifiable

    ifr.setBounds( 10, 10, 200, 200 );

    desktop.add( ifr, new Integer(300) );

    ifr.show();

    ifr.setBackground( new java.awt.Color(255, 0, 0, 50) );



    javax.swing.JLabel lbl = new javax.swing.JLabel("This is a label");

    lbl.setBackground( java.awt.Color.green );

    lbl.setForeground( java.awt.Color.orange );

    lbl.setBounds(10,10,200,100);

    desktop.add( lbl, new Integer(301) );



    javax.swing.JInternalFrame[] content = desktop.getAllFrames();

    for( int i = 0; i < content.length; i++)

    System.out.println( content[i].getLayer() + "     "+ content[i] );

} }



class MouseClickListener implements MouseListener

{

  public void mouseClicked( MouseEvent e ){ openPopup(e); }

  public void mouseEntered( MouseEvent e ){ openPopup(e); }

  public void mouseExited( MouseEvent e ){}

  public void mousePressed( MouseEvent e ){ openPopup(e); }

  public void mouseReleased( MouseEvent e ){ openPopup(e); }

  private void openPopup(MouseEvent e)

  { if(e.isPopupTrigger())

    { ThePopupMenu x = new ThePopupMenu();

      x.show( (java.awt.Component)e.getSource() ,e.getX(),e.getY());

} } }



class ThePopupMenu extends JPopupMenu implements ActionListener

{ ThePopupMenu()

  { super("Title");

    JMenuItem item;

    this.add( item = new JMenuItem("Exit"));

    item.addActionListener( this);

  }

  public void actionPerformed( ActionEvent e ){ System.exit( 0 ); }

}








/*
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway% javac DesktopDemo.java
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway% java DesktopDemo
(Exit command by pressing the auxilliary mouse-key for the popup-window)
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/Interaction > javac DesktopDemo.java
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/Interaction > java DesktopDemo
javax.swing.DefaultDesktopManager@3753f8
300     javax.swing.JInternalFrame[,10,10,200x200,layout=javax.swing.plaf.basic.
BasicInternalFrameUI$InternalFrameLayout,alignmentX=null,alignmentY=null,border=
javax.swing.plaf.metal.MetalBorders$InternalFrameBorder@5b699b,flags=32,maximumSize=
,minimumSize=java.awt.Dimension[width=120,height=31],preferredSize=,closable=true,
defaultCloseOperation=DISPOSE_ON_CLOSE,desktopIcon=javax.swing.JInternalFrame$JDesktopIcon[
,0,0,150x28,invalid,layout=java.awt.BorderLayout,alignmentX=null,alignmentY=null,
border=javax.swing.plaf.BorderUIResource$CompoundBorderUIResource@5329c5,flags=32,
maximumSize=,minimumSize=,preferredSize=],frameIcon=javax.swing.plaf.metal.MetalIconFactory$
InternalFrameDefaultMenuIcon@292d26,iconable=false,isClosed=false,isIcon=false,isMaximum=false,
isSelected=true,maximizable=true,opened=true,resizable=true,rootPane=javax.swing.JRootPane[,
5,26,190x169,layout=javax.swing.JRootPane$RootLayout,alignmentX=null,alignmentY=null,border=,
flags=1538,maximumSize=,minimumSize=,preferredSize=],rootPaneCheckingEnabled=true,title=InternalFrame]
(Exit command by pressing the auxilliary mouse-key for the popup-window)
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/Interaction >
*/

/*
C:\JavaCodeFiles\SingleUserInterface\Interaction>javac DesktopDemo.java

C:\JavaCodeFiles\SingleUserInterface\Interaction>java  DesktopDemo
javax.swing.DefaultDesktopManager@77158a
300    javax.swing.JInternalFrame[,10,10,200x200,layout=javax.swing.plaf.basic.B
asicInternalFrameUI$InternalFrameLayout,alignmentX=null,alignmentY=null,border=j
avax.swing.plaf.metal.MetalBorders$InternalFrameBorder@f6235,flags=32,maximumSiz
e=,minimumSize=java.awt.Dimension[width=120,height=34],preferredSize=,closable=t
rue,defaultCloseOperation=DISPOSE_ON_CLOSE,desktopIcon=javax.swing.JInternalFram
e$JDesktopIcon[,0,0,132x32,invalid,layout=java.awt.BorderLayout,alignmentX=null,
alignmentY=null,border=javax.swing.plaf.BorderUIResource$CompoundBorderUIResourc
e@7e748f,flags=32,maximumSize=,minimumSize=,preferredSize=],frameIcon=javax.swin
g.plaf.metal.MetalIconFactory$InternalFrameDefaultMenuIcon@544ec1,iconable=false
,isClosed=false,isIcon=false,isMaximum=false,isSelected=true,maximizable=true,op
ened=true,resizable=true,rootPane=javax.swing.JRootPane[,5,29,190x166,layout=jav
ax.swing.JRootPane$RootLayout,alignmentX=null,alignmentY=null,border=,flags=1538
,maximumSize=,minimumSize=,preferredSize=],rootPaneCheckingEnabled=true,title=In
ternalFrame]
(Exit command by pressing the auxilliary mouse-key for the popup-window)
C:\JavaCodeFiles\SingleUserInterface\Interaction>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






