import java.awt.image.MemoryImageSource;



public class AnimateImageArray

{

  public static void main( String unused[] ) // -------------------------------- main

  { javax.swing.JFrame desktopFrame = new javax.swing.JFrame();

    UpdatableLabel label = new UpdatableLabel();

    desktopFrame.getContentPane().add( label, "South" );

    desktopFrame.setSize( new java.awt.Dimension(200,220) );

    desktopFrame.setVisible(true);

    final Projector projector =

                        new Projector( new ImageArrayExample( label ).handover() );

    desktopFrame.getContentPane().add( projector, "Center" );

    projector.addPropertyChangeListener( label );

    desktopFrame.validate(); // If omitted, the display window stops.

    /* while(true){ projector.repaint();try{Thread.sleep( 400 );}

                    catch(java.lang.Exception e){ e.printStackTrace(); };}    */

    new javax.swing.Timer

    ( 100 ,                                 // delay in milliseconds

      new java.awt.event.ActionListener()   // repaint on timing signal

      { public void actionPerformed( java.awt.event.ActionEvent e )

        { projector.repaint(); }

      }

    ).start();

} }



class UpdatableLabel

extends javax.swing.JLabel implements java.beans.PropertyChangeListener

{ public void propertyChange( java.beans.PropertyChangeEvent e)

  { setText(e.getPropertyName() + e.getNewValue() );

} }



class Projector extends javax.swing.JComponent

{ int j, noOfImages;

  java.awt.Image [] image;             // array of images

  java.awt.Point imageOrigin;

  Projector( java.awt.Image image[] )  // constructor,

  { noOfImages = image.length;         // draws a given image-array onto the screen.

    this.image = image;

    imageOrigin = new java.awt.Point(0,0);

    this.setPreferredSize( new java.awt.Dimension(image[0].getWidth(this),

                                                        image[0].getHeight(this)) );

  }

  public void paint( java.awt.Graphics g ) // or paintComponent()

  { j++;

    g.drawString( "Hello World!", 30, 30 );

    g.drawImage( image[j], imageOrigin.x, imageOrigin.y, this );

    // System.out.println("image number " + j + " painted.");

    firePropertyChange("painted image no.", new Integer(j-1), new Integer(j));

    if( j == noOfImages-1 ) j = -1;

} }



class ImageArrayExample extends javax.swing.JComponent

{ int noOfImages = 10;     // allows to fire property-change-event

  int [] pixArray;

  java.awt.Image [] image = new java.awt.Image[ noOfImages ];    // array of images

  ImageArrayExample( java.beans.PropertyChangeListener listener )

  { int width = 200,                       // constructor, produces the image-array

        height = 200,

        firstPix = 0,       // begin with first entry in array pixArray

        lineLength = width; // number of pixels per horizontal lineLength

    addPropertyChangeListener( listener );

    for(int i = 0; i < noOfImages; i++)

    { pixArray = createPixArray(width, height, (float)i/(float)noOfImages );

      MemoryImageSource mis =

          new MemoryImageSource(width, height, pixArray, firstPix, lineLength);

      image[i] = java.awt.Toolkit.getDefaultToolkit() .createImage( mis );

      firePropertyChange("created image no.", new Integer(i-1), new Integer(i));

      // System.out.println("image number " + i + " generated.");

  } }



  int [] createPixArray(int width, int height, float parameter)

  { int pixArrayLength = width * height;   // ------------ composing a single image

    int [] pixArray = new int[ pixArrayLength ];

    int blue, green, red, alpha, x, y, value, div = width * width + height * height;

    float phase;

    for(int i = 0; i < pixArrayLength; i++)

    { x =i % width;

      y = i / width;

      phase=(float)(x*x + y*y) / (float)div;

      value = (int)( 255 * java.lang.Math.pow(

              java.lang.Math.sin( java.lang.Math.PI * (phase - parameter) ),

              2) );

      red = alpha = value; green = 100; blue = 200;

      pixArray[i] = Transform.intFromBytes(blue, green, red, alpha);

    }

    return pixArray;

  }

  java.awt.Image [] handover(){ return image; }

}



class Transform

// uses int-variable to store an array of four unsigned byte-values

// (used by ARGB color model)

{ static int intFromBytes(int one, int two, int three, int four) // int range 0..255

  { int [] handover = {one,two,three,four};

    return intFromBytes(handover);

  }

  static int intFromBytes(int [] b) // that's b[0],b[1],... least significant first

  // the work is done in the return clause the rest are machinations to avoid errors

  { int [] intArray = new int[4];

    boolean smaller, larger, right;

    for(int i = 0; i < b.length; i++)

    { smaller = b[i] < 0;

      larger = b[i] > 255;

      right = !smaller & !larger;

      if(smaller) intArray[i] = 0;

      if(larger) intArray[i] = 255;

      if(right) intArray[i] = b[i];

    }

    return intArray[3] << 24 | intArray[2] << 16 | intArray[1] << 8 | intArray[0];

  }

  static int [] bytesFromInt(int n)

  { final int BIT_MASK = 255; // binary = 00000000 00000000 00000000 11111111

    int [] b = {0,0,0,0}; // cannot be written in one line return {(byte) n & BIT_MASK, ...};

    b[0] = n & BIT_MASK; // extracts

    b[1] = (n >> 8) & BIT_MASK;

    b[2] = (n >> 16) & BIT_MASK;

    b[3] = (n >> 24) & BIT_MASK;

    return b;

} }







/*
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway% javac AnimateImageArray.java
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway% java AnimateImageArray
^C
[localhost:~/JavaCodeFiles/SingleUserInterface/Interaction] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/Interaction > javac AnimateImageArray.java
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/Interaction > java AnimateImageArray
(CTRL-C)
marycosway@linux:~/JavaCodeFiles/SingleUserInterface/Interaction >
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






