import java.awt.Component;

import java.awt.AWTEvent;

import java.awt.event.ActionEvent;

import java.awt.AWTEventMulticaster;

import java.awt.event.ActionListener;

import java.awt.EventQueue;

// main()-method found in class "RollerCoaster"



class OscillatingTimer extends java.awt.Component implements Runnable

{ EventQueue q;

  OscillatingTimer()

  { super();

    enableEvents( java.awt.AWTEvent.ACTION_EVENT_MASK );

/*  // the conventional approach, here out-commented.

    this.addActionListener

    ( new ActionListener()

      { public void actionPerformed( ActionEvent e )

        { System.out.println( e.getActionCommand() + " action event happened");

      } }

    );

*/

    // setEnabled(true); // for screen input (default)

    q = getToolkit().getSystemEventQueue();

    new Thread( this ).start();

  } // end of constructor



  public void run()

  { float x = 0; int d = 0;

    while(true)

    { x = x + (float)0.1;

      d = java.lang.Math.round( 500*(float)(java.lang.Math.cos(x)+1) );

      System.out.println(" Delay in milliseconds: " + d );

      try { Thread.sleep( d ); }catch( Exception e ){ e.printStackTrace(); };

      ActionEvent e =

                  new ActionEvent( this, ActionEvent.ACTION_PERFORMED, "TimerSignal" );

      //dispatchEvent( e ); // alternative, out-commented

      processEvent( e ); ////> sending an event-object by calling processEvent() >////

      /* // out-commented alternatives for experimentation

        q.postEvent( e );

        AWTEvent xx = q.peekEvent();

        System.out.println("Eventqueue: " + xx.toString() );

        //q.dispatchEvent( (AWTEvent)e );

      */

  } }

  ActionListener actionListener = null;

  public synchronized void addActionListener( ActionListener l )

  { actionListener = AWTEventMulticaster.add( actionListener, l );

  }

  public synchronized void removeActionListener( ActionListener l )

  { actionListener = AWTEventMulticaster.remove( actionListener, l );

  }

  public void processEvent( AWTEvent e ) ////> handling an event directly >////

  { if (actionListener != null)

    { actionListener.actionPerformed( (ActionEvent)e ); // no event-queue

    }

    //super.processEvent( e );

             ////> forwarding the event-object to be processed regularly >////

} }



public class RollerCoaster implements ActionListener

{ public static void main( String unused[] )

  { RollerCoaster t = new RollerCoaster();

    OscillatingTimer o = new OscillatingTimer();

    o.addActionListener( t );

   }

   public void actionPerformed( ActionEvent e )

   { System.out.println( e.getActionCommand() + " action-event received " );

     // isEventdispatchThread ??? Yes.

} }








/*
[localhost:~/JavaCodeFiles/SingleUserInterface/Events] jacobneuhaus% javac RollerCoaster.java
[localhost:~/JavaCodeFiles/SingleUserInterface/Events] jacobneuhaus% java RollerCoaster
 Delay in milliseconds: 998
TimerSignal action event received
 Delay in milliseconds: 990
TimerSignal action event received
 Delay in milliseconds: 978
TimerSignal action event received
...
^C (Ctrl-C)
[localhost:~/JavaCodeFiles/SingleUserInterface/Events] jacobneuhaus% 
*/

/*
jacobneuhaus@linux:~/JavaCodeFiles/SingleUserInterface/Events > javac RollerCoaster.java
jacobneuhaus@linux:~/JavaCodeFiles/SingleUserInterface/Events > java RollerCoaster
 Delay in milliseconds: 998
TimerSignal action-event received
 Delay in milliseconds: 990
TimerSignal action-event received
 Delay in milliseconds: 978
TimerSignal action-event received
 Delay in milliseconds: 961
TimerSignal action-event received
 Delay in milliseconds: 939
TimerSignal action-event received
 Delay in milliseconds: 913
...
(Ctrl-C)
jacobneuhaus@linux:~/JavaCodeFiles/SingleUserInterface/Events >
*/


/*
C:\JavaCodeFiles\SingleUserInterface\Events>javac RollerCoaster.java

C:\JavaCodeFiles\SingleUserInterface\Events>java RollerCoaster
 Delay in milliseconds: 998
TimerSignal action-event received
 Delay in milliseconds: 990
TimerSignal action-event received
 Delay in milliseconds: 978
TimerSignal action-event received
 Delay in milliseconds: 961
TimerSignal action-event received
 Delay in milliseconds: 939
TimerSignal action-event received
 Delay in milliseconds: 913
...
(Ctrl-C)
C:\JavaCodeFiles\SingleUserInterface\Events>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






