import javax.swing.JWindow;

import java.awt.event.MouseListener;

import java.awt.event.MouseMotionListener;

import java.awt.event.InputEvent;

import java.awt.event.MouseEvent;



class Mouse

{ public static void main( String unused[] )

  {

    JWindow pane = new JWindow();

    pane.addMouseListener( new MouseClickListener() );

    pane.addMouseMotionListener( new MovingMouseListener() );

    pane.setSize( 200, 200 );

    pane.setVisible( true );

} }



class MouseClickListener implements MouseListener

{

  private void out( String text ){ System.out.println( text ); }

  public void mouseClicked( MouseEvent e )

  { out("Clicked");

    if( ( e.getModifiers() & InputEvent.BUTTON1_MASK ) !=0 ) out( "left/main" );

    if( ( e.getModifiers() & InputEvent.BUTTON2_MASK ) !=0 ) out( "middle/main" );

    if( ( e.getModifiers() & InputEvent.BUTTON3_MASK ) !=0 ) out( "right" );

    switch( e.getClickCount() )

    { case 1: out(" Once");   break;

      case 2: out(" Double"); break;

      case 3: out(" Triple");

  } }

  public void mouseEntered( MouseEvent e ){ out( "Entered" ); }

  public void  mouseExited( MouseEvent e ){ out( "Exited" );  }

  public void mousePressed( MouseEvent e )

  { if( e.isAltDown() )      out( "Pressed with AltDown" );

    if( e.isControlDown() )  out( "Pressed with ControlDown" );

    if( e.isMetaDown() )     out( "Pressed with MetaDown" );

    if( e.isAltGraphDown() ) out( "Pressed with AltGraphDown" );

    if( e.isShiftDown() )    out( "Pressed with ShiftDown" );

  }

  public void mouseReleased( MouseEvent e ){ out( "Released" ); }

}



class MovingMouseListener implements MouseMotionListener

{ public void mouseMoved( MouseEvent e )

  { System.out.println( "Move: " + e.getX() + " " + e.getY() );

  }

  public void mouseDragged( MouseEvent e )

  { System.out.println( "Drag: " + e.getX() + " " + e.getY() );

} }

/* Click + ALT (ALT or ALTGR) = middle mouse key, if existent.

   Click + META (Apple key) = right mouse key, if existent.

   Click + SHIFT = left mouse key or main mouse key

*/










/*
[localhost:~/JavaCodeFiles/SingleUserInterface/Events] jacobneuhaus% javac Mouse.java
[localhost:~/JavaCodeFiles/SingleUserInterface/Events] jacobneuhaus% java Mouse
Entered
Move: 181 198
Move: 180 198
Move: 180 197
Move: 179 197
Move: 179 196
Move: 179 195
Move: 178 195
Released
Clicked
left/main
 Once
Released
Clicked
left/main
 Once
Released
Clicked
left/main
 Double
Move: 178 194
Move: 177 194
Move: 176 193
Pressed with AltDown
Pressed with ControlDown
Drag: 175 193
Drag: 175 192
Drag: 174 192
Drag: 173 192
Drag: 172 192
Drag: 171 192
Drag: 170 191
Released
Pressed with MetaDown
Released
Clicked
right
 Once
Pressed with AltDown
Released
Clicked
middle/main
 Once
Move: 170 192
Move: 170 194
Move: 171 194
Move: 172 199
Exited



Entered
Move: 17 1
Move: 17 3
Move: 17 4
Move: 17 6
Move: 16 7
Move: 15 6
Released
Clicked
left
Once
Drag: 16 9
Drag: 17 11
Drag: 17 12
Drag: 17 13
Drag: 17 14
Released
Pressed with MetaDown
Released
Clicked
right
Once
Move: 17 15
Move: 18 15
Released
Clicked
left
Once
Released
Clicked
left
Double
Move: 18 14
...
Move: 20 1
Exited
(Make the terminal-window the top-level-window, by clicking it and enter Ctrl-C to terminate)
^C
[localhost:~/JavaCodeFiles/SingleUserInterface/Events] jacobneuhaus%
*/

/*
jacobneuhaus@linux:~/JavaCodeFiles/SingleUserInterface/Events > javac Mouse.java
jacobneuhaus@linux:~/JavaCodeFiles/SingleUserInterface/Events > java Mouse
Entered
Move: 197 149
Move: 196 149
Move: 195 149
Move: 194 149
Move: 193 149
Move: 192 149
Move: 191 149
Drag: 190 149
Drag: 189 149
Drag: 188 149
Drag: 187 149
Drag: 187 150
Released
Pressed with MetaDown
Drag: 187 151
Drag: 187 152
Drag: 187 153
Drag: 186 153
Released
Pressed with AltDown
Drag: 185 153
Drag: 183 155
Drag: 183 156
Drag: 181 158
Drag: 181 159
Drag: 181 160
Drag: 181 161
Drag: 182 161
Drag: 182 162
Released
Move: 183 162
Move: 184 162
Move: 184 161
Move: 185 161
Move: 186 161
Move: 187 161
Move: 189 159
Move: 191 157
Move: 192 157
Move: 193 157
Move: 194 157
Move: 195 157
Move: 196 157
Move: 197 157
Move: 198 157
Move: 199 157
Exited
(Ctrl-C in terminal-window)
jacobneuhaus@linux:~/JavaCodeFiles/SingleUserInterface/Events >





C:\JavaCodeFiles\SingleUserInterface\Events>javac Mouse.java

C:\JavaCodeFiles\SingleUserInterface\Events>java Mouse
Entered
Move: 199 190
Move: 198 190
Released
Clicked
left/main
 Once
Drag: 197 191
Drag: 197 193
Drag: 197 194
Drag: 198 194
Drag: 199 195
Exited
Drag: 201 196
Drag: 202 197
Drag: 204 198
Drag: 205 198
Drag: 207 198
Drag: 279 209
Released
(Ctrl-C in DOS-window)
C:\JavaCodeFiles\SingleUserInterface\Events>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






