// Button presses are memorized, but not acknowledged, and then are processed sequentially.

// (The button does not block)

import javax.swing.JFrame;

import javax.swing.JButton;

import java.awt.event.ActionListener; // interface

import java.awt.event.ActionEvent;

import javax.swing.SwingUtilities;



public class GUILowLatency

{

  public static void main( String unused[] ) throws Exception

  { JFrame aFrame = new JFrame( "GUI Reacts Slowly" );

    JButton aButton = new JButton( "Press multiply and watch terminal" );

    aFrame.getContentPane().add( aButton );

    aFrame.setSize( 300, 100 );

    aFrame.setVisible( true );

    ActionListener al = new AButtonActionListener();

    aButton.addActionListener( al );

    System.out.println( " main-thread, event-dispatch-thread? "

                                             + SwingUtilities.isEventDispatchThread() );

} }

class AButtonActionListener implements ActionListener

{ static char eventID= 64; // 65 = 'A'

  public void actionPerformed( ActionEvent e ) ////////////////////// the blocking method

  { eventID++;

    int i = 0;

    while( ++i < 10 ){ System.out.print( " " + eventID );

    try{ Thread.sleep(1000); }

    catch( java.lang.InterruptedException evt ){ evt.printStackTrace(); }

  }

  System.out.println

  ( " button-press has been processed, in event-dispatch-thread? "

    + SwingUtilities.isEventDispatchThread()

  );

} }





/*
[localhost:~/JavaCodeFiles/SingleUserInterface/Events] jacobneuhaus% javac GUILowLatency.java
[localhost:~/JavaCodeFiles/SingleUserInterface/Events] jacobneuhaus% java GUILowLatency
 main-thread, event dispach thread? false
 A A A A A A A A A button-press has been processed, event dispach thread? true
 B B B B B B B B B button-press has been processed, event dispach thread? true
 C C C C C C C C C button-press has been processed, event dispach thread? true
 D D D D D D D D D button-press has been processed, event dispach thread? true
^C (Ctrl-C)
[localhost:~/JavaCodeFiles/SingleUserInterface/Events] jacobneuhaus%
*/

/*
jacobneuhaus@linux:~/JavaCodeFiles/SingleUserInterface/Events > javac GUILowLatency.java
jacobneuhaus@linux:~/JavaCodeFiles/SingleUserInterface/Events > java GUILowLatency
 main-thread, event dispach thread? false
 A A A A A A A A A button-press has been processed, event dispach thread? true
 B B B B B B B B B button-press has been processed, event dispach thread? true
 C C C C C C C C C button-press has been processed, event dispach thread? true
 (Ctrl-C)
jacobneuhaus@linux:~/JavaCodeFiles/SingleUserInterface/Events >
*/

/*
C:\JavaCodeFiles\SingleUserInterface\Events>javac GUILowLatency.java

C:\JavaCodeFiles\SingleUserInterface\Events>java GUILowLatency
 main-thread, event dispach thread? false
 A A A A A A A A A button-press has been processed, event dispach thread? true
 B B B B B B B B B button-press has been processed, event dispach thread? true
 C C C C C C C C C button-press has been processed, event dispach thread? true
 (Ctrl-C)
C:\JavaCodeFiles\SingleUserInterface\Events>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






