/*
The source-code below prints out the contents of a text-file.
This text has to be read from the Hierarchical File Systen (HFS).
The user has the choice of two getFile()-methods.
These two getFile()-methods are implemented in classes of different class-loader,
than this code.
(The user of this program can choose between those methods by entering 1 or 2 when
 starting this program.)
The source- or byte-code of the classes 'MethodCall2' and  'MethodCall2Privileged'
are to be placed into a folder './OtherFolder' ('.' means relative to the directory
in which the code below is run.)
*/
//import OtherFolder.*; // *******************************
/* outcommented like the package declaration in the files MethodCall2.java and MethosCall2Privileged.java
   The outcommenting here shows how to incorporate classes from other directories 
   and/or originating from other class-loaders without needing a package construct!
   For working with a standard package remove the outcommenting parts marked by *********************
   and compile the entire source-code with 'javac MethodCall1.java'
*/

class MethodCall1 
{ public static void main( String oneOrTwo[] ) // <-- main()-method call, the first method-call
  { //System.out.println( System.getProperty( "user.home" ) );  
    try
    {
 //Class cl = Class.forName("MethodCall1");
 //System.out.println(cl.getClassLoader().toString() + cl.getProtectionDomain());
      java.io.FileReader fr = null;
      switch( Integer.parseInt( oneOrTwo[0] ) )
      { case 1: MethodCall2 x = new MethodCall2(); 
                fr = x.getFile(); // <--- getFile()-method call, the second method-call
                break;
        case 2: MethodCall2Privileged y = new MethodCall2Privileged(); 
                fr = y.getFile(); // <--- getFile()-method call, the second method-call
                break;
      }
      java.io.BufferedReader br = new java.io.BufferedReader( fr );
      String s;
      while( true )
      { s = br.readLine();
        if( s == null ) break;
        System.out.println(s);
      }
      br.close();
    }catch( java.lang.Exception e){ e.printStackTrace(); }
} }
/*
Why MethodCall not in this file and not in this directory?
Because other directory (giving a different code-source) allows to define different set of permissions.
*/
/* The permissions as  given in the '.java.policy'-file work in the privileged case because there they stand alone.
   In the non-privileged case those permissions are tested agains the default permissions which do not allow the
   unrestricted access of other directories.
*/






/* PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES 
 Inside the text-file 'java.policy' in the directory $JAVAHOME/lib/security
 or inside the text-file '.java.policy' in the user's home-directory  ~/ 
  (the directory Windows 98, for example:  C:\Programs\JavaSoft\JRE\1.3.1\lib\security\java.policy )
  have to be inserted the following lines:

                                     //  below is a Uniform Resource Locator (URL)
grant codeBase "file:${user.home}/JavaCodeFiles/JRESecurity/PolicyBasedSecurity/OtherFolder/-"
{                                  //  below is a relative path of the platform-specific Hierarchical File System (HFS-path)
  permission java.util.PropertyPermission "user.home","read";
  permission java.io.FilePermission "${user.home}/JavaCodeFiles/BASIC_INFORMATION.txt","read";
//  permission java.security.AllPermission;
};
// Within the string "...ity/PolicyBasedSecurity/-"
// symbol '*' means: all files and directory-names inside the directory of the prefixing path-name
// symbol '-' means: all files inside the directory of the prefixing path-name, INCLUDING the files of all subdirectories
// A string "<<ALL FILES>>" covers the entire file-hierarchy

PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES */


/*
[localhost:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity] andreadipietro% javac -classpath ./OtherFolder MethodCall1.java
[localhost:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity] andreadipietro% java -classpath .:./OtherFolder -Djava.security.manager MethodCall1 1
MethodCall2 loaded
MethodCall2 instantiated
java.security.AccessControlException: access denied (java.util.PropertyPermission user.home read)
        at java.security.AccessControlContext.checkPermission(AccessControlContext.java:272)
        at java.security.AccessController.checkPermission(AccessController.java:399)
        at java.lang.SecurityManager.checkPermission(SecurityManager.java:545)
        at java.lang.SecurityManager.checkPropertyAccess(SecurityManager.java:1278)
        at java.lang.System.getProperty(System.java:560)
        at MethodCall2.getFile(MethodCall2.java:7)
        at MethodCall1.main(MethodCall1.java:27)
[localhost:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity] andreadipietro% java -classpath .:./OtherFolder -Djava.security.manager MethodCall1 2
MethodCall2Privileged loaded
MethodCall2Privileged instantiated
This text ..... (Contents of the file ~/JavaCodeFiles/BASIC_INFORMATION.txt)
[localhost:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity] andreadipietro% 
*/

/*
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity > javac -classpath ./OtherFolder MethodCall1.java
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity > java -classpath .:./OtherFolder -Djava.security.manager MethodCall1 1
MethodCall2 loaded
MethodCall2 instantiated
java.security.AccessControlException: access denied (java.util.PropertyPermission user.home read)
        at java.security.AccessControlContext.checkPermission(AccessControlContext.java:272)
        at java.security.AccessController.checkPermission(AccessController.java:399)
        at java.lang.SecurityManager.checkPermission(SecurityManager.java:545)
        at java.lang.SecurityManager.checkPropertyAccess(SecurityManager.java:1278)
        at java.lang.System.getProperty(System.java:560)
        at MethodCall2.getFile(MethodCall2.java:7)
        at MethodCall1.main(MethodCall1.java:30)
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity > java -classpath .:./OtherFolder -Djava.security.manager MethodCall1 2
MethodCall2Privileged loaded
MethodCall2Privileged instantiated
This text ..... (Contents of the file ~/JavaCodeFiles/BASIC_INFORMATION.txt)
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity >
*/






/* 
Windows PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES 
 Into the directory Windows 98, for example:  C:\Programs\JavaSoft\JRE\1.3.1\lib\security\java.policy 
  have to be inserted the following lines:

                                     //  below is a Uniform Resource Locator (URL)
grant codeBase "file: c:/JavaCodeFiles/JRESecurity/PolicyBasedSecurity/OtherFolder/-"
{                                  //  below is a relative path of the platform-specific Hierarchical File System (HFS-path)
  permission java.util.PropertyPermission "c:","read";
  permission java.io.FilePermission "c:/JavaCodeFiles/BASIC_INFORMATION.txt","read";
//  permission java.security.AllPermission;
};
// Within the string "...ity/PolicyBasedSecurity/-"
// symbol '*' means: all files and directory-names inside the directory of the prefixing path-name
// symbol '-' means: all files inside the directory of the prefixing path-name, INCLUDING the files of all subdirectories
// A string "<<ALL FILES>>" covers the entire file-hierarchy

AND
in the source-codes ${user.home} has to be substituted by 'c:' 

Windows PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES PREREQUISITES

C:\JavaCodeFiles\JRESecurity\PolicyBasedSecurity>javac -classpath .\OtherFolder MethodCall1.java

C:\JavaCodeFiles\JRESecurity\PolicyBasedSecurity>java  -classpath .;.\OtherFolder -Djava.security.manager MethodCall1 1
MethodCall2 loaded
MethodCall2 instantiated
java.security.AccessControlException: access denied (java.util.PropertyPermission user.home read)
        at java.security.AccessControlContext.checkPermission(Unknown Source)
        at java.security.AccessController.checkPermission(Unknown Source)
        at java.lang.SecurityManager.checkPermission(Unknown Source)
        at java.lang.SecurityManager.checkPropertyAccess(Unknown Source)
        at java.lang.System.getProperty(Unknown Source)
        at MethodCall2.getFile(MethodCall2.java:7)
        at MethodCall1.main(MethodCall1.java:30)

C:\JavaCodeFiles\JRESecurity\PolicyBasedSecurity> java -classpath .:./OtherFolder -Djava.security.manager MethodCall1 2
MethodCall2Privileged loaded
MethodCall2Privileged instantiated
..... (Contents of the file ~/JavaCodeFiles/BASIC_INFORMATION.txt)

C:\JavaCodeFiles\JRESecurity\PolicyBasedSecurity> 
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






