class CustomSecurityManager extends java.lang.SecurityManager  ///////////////////////

{ public void checkRead( String fileName )

  { if( ! fileName.startsWith("Merg") )

    { throw new java.lang.SecurityException( "checkRead: " + fileName +

                                             " does not begin with Merg: No access" );

    }

    super.checkRead( fileName );

    // Java Version 1.2 and higher for additional policy-based access-control.

} }



public class MergeWithSM

{

  static void fileToConsole( String fileName )

  { try

    { java.io.FileReader fr = new java.io.FileReader( fileName );

      java.io.BufferedReader br = new java.io.BufferedReader( fr );

      String s;

      while( true )

      { s = br.readLine();

        if( s == null ) break;

        System.out.println(s);

      }

      br.close();

    }catch( Exception e ){ e.printStackTrace(); }

  } // end fileToConsole()-method



 static void merge( String source1AndDestination, String source2 )

  { try

    { java.io.FileWriter fw = new java.io.FileWriter( source1AndDestination, true );

      java.io.FileReader fr = new java.io.FileReader( source2 );

      java.io.BufferedReader br = new java.io.BufferedReader( fr );

      String s;

      while( true )

      { s = br.readLine();

        if( s == null ) break;

        fw.write( s, 0, s.length() );

      }

      br.close(); fw.close();

    }catch(Exception e){ e.printStackTrace(); }

  }



  public static void main( String [] fileNames )

  { System.setSecurityManager( new CustomSecurityManager() ); ///////////////////

    int toBeMerged = fileNames.length;

    switch( toBeMerged )

    { case 2: merge( fileNames[0], fileNames[1] );

      case 1: fileToConsole( fileNames[0] ); break;

      default: System.out.println("Merge: enter one or two filenames");

    }

} } // class and main()-method









/*
(CASE: ---- NO PERMISSION ---- file-name does not begin with 'Merg')
[localhost:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity] andreadipietro% javac MergeWithSM.java
[localhost:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity] andreadipietro% java MergeWithSM DemoFile.txt
java.lang.SecurityException: checkRead: DemoFile.txt does not begin with Merg: No access
        at CustomSecurityManager.checkRead(MergeWithSM.java:4)
        at java.io.FileInputStream.<init>(FileInputStream.java:61)
        at java.io.FileReader.<init>(FileReader.java:38)
        at MergeWithSM.fileToConsole(MergeWithSM.java:12)
        at MergeWithSM.main(MergeWithSM.java:42)
[localhost:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity] andreadipietro%

(CASE: ---- PERMISSION ----)
[localhost:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity] andreadipietro% java MergeWithSM MergeWithSM.java
.... (this listing)
[localhost:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity] andreadipietro%
*/

/*
(CASE: ---- NO PERMISSION ---- file-name does not begin with 'Merg')
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity > javac MergeWithSM.java
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity > java MergeWithSM DemoFile.txt
java.lang.SecurityException: checkRead: DemoFile.txt does not begin with Merg: No access
        at CustomSecurityManager.checkRead(MergeWithSM.java:4)
        at java.io.FileInputStream.<init>(FileInputStream.java:61)
        at java.io.FileReader.<init>(FileReader.java:38)
        at MergeWithSM.fileToConsole(MergeWithSM.java:12)
        at MergeWithSM.main(MergeWithSM.java:41)


(CASE: ---- PERMISSION ----)
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity > java MergeWithSM  MergeWithSM.java
.... (this listing)
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/PolicyBasedSecurity >
*/

/*
(CASE: ---- NO PERMISSION ---- file-name does not begin with 'Merg')
C:\JavaCodeFiles\JRESecurity\PolicyBasedSecurity>javac MergeWithSM.java

C:\JavaCodeFiles\JRESecurity\PolicyBasedSecurity>java  MergeWithSM DemoFile.txt
java.lang.SecurityException: checkRead: DemoFile.txt does not begin with Merg: No access
        at CustomSecurityManager.checkRead(MergeWithSM.java:4)
        at java.io.FileInputStream.<init>(Unknown Source)
        at java.io.FileReader.<init>(Unknown Source)
        at MergeWithSM.fileToConsole(MergeWithSM.java:12)
        at MergeWithSM.main(MergeWithSM.java:41)

C:\JavaCodeFiles\JRESecurity\PolicyBasedSecurity>

(CASE: ---- PERMISSION ----)
C:\JavaCodeFiles\JRESecurity\PolicyBasedSecurity>java MergeWithSM  MergeWithSM.java
.... (this listing)
C:\JavaCodeFiles\JRESecurity\PolicyBasedSecurity>
*/




/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






