/* The program below loads a class ToBeSearched by searching it within given

   list of Uniform Resource Locators (URLs).

*/

class URLLoad

{ static java.net.URL urlSearchList[] = new java.net.URL[3];

  public static void main( String unused[] )                        // main()-method

  { try

    { // Uniform Resource Locator's format is independent of platform used

      { urlSearchList[0] = new java.net.URL("file:/Users/andreadipietro/JavaCodeFiles/JRESecurity/PolicyBasedSecurity/");

           urlSearchList[1] = new java.net.URL("file:/Users/andreadipietro/JavaCodeFiles/JRESecurity/DataCodingSecurity/");

           urlSearchList[2] = new java.net.URL("file:/Users/andreadipietro/JavaCodeFiles/JRESecurity/");

      }

    }catch( java.net.MalformedURLException e ){ e.printStackTrace(); }

    try

    { java.lang.ClassLoader parent = Class.forName("URLLoad").getClassLoader();

      java.net.URLClassLoader urlCL =

                                  new java.net.URLClassLoader( urlSearchList, parent );

      Class x = urlCL.loadClass( "ToBeSearched" ); // <<-- The Searching Triggered --

      System.out.println( " " + x.getClassLoader());

/* Which class-loader is used, URLClassLoader or parent class-loader,

   depends in which directory the class-file of the class below is placed.

*/

      x.newInstance();

    }catch( java.lang.ClassNotFoundException e ){ System.out.println(e); }

     catch( java.lang.IllegalAccessException e ){ System.out.println(e); }

     catch( java.lang.InstantiationException e ){ System.out.println(e); }

} }





/*
(ToBeSearched uncompiled) [localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% javac URLLoad.java
(ToBeSearched uncompiled) [localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% java URLLoad
(ToBeSearched uncompiled) java.lang.ClassNotFoundException: ToBeSearched
(ToBeSearched uncompiled) [localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% 
// When file ToBeSearched.class is in current directory or a directory of the CLASSPATH-variable:
[localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% javac URLLoad.java
[localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% java URLLoad
 sun.misc.Launcher$AppClassLoader@33056f
class ToBeSearched loaded!
class ToBeSearched instantiated!
[localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% 

// When file ToBeSearched.class is in a directory of the urlSearchList:
[localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% java URLLoad
 java.net.URLClassLoader@7c6c7
class ToBeSearched loaded!
class ToBeSearched instantiated!
[localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% 
*/

/* if ToBeSearched DECLARED WITHOUT MODIFIER "public",
class can be only called from classes and objects in the name-space of the URLClassLoader urlCL
[localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% java URLLoad
 java.net.URLClassLoader@7c6c7
class ToBeSearched loaded!
java.lang.IllegalAccessException: ToBeSearched
[localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro%
*/



/*
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/JREClassLoading > javac URLLoad.java
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/JREClassLoading > java URLLoad
 sun.misc.Launcher$AppClassLoader@6f241
class ToBeSearched loaded!
class ToBeSearched instantiated!
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/JREClassLoading >
*/



/*
C:\JavaCodeFiles\JRESecurity\JREClassLoading>javac URLLoad.java

C:\JavaCodeFiles\JRESecurity\JREClassLoading>java URLLoad
 sun.misc.Launcher$AppClassLoader@71732b
class ToBeSearched loaded!
class ToBeSearched instantiated!

C:\JavaCodeFiles\JRESecurity\JREClassLoading>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






