/* source-code in file named LoaderDemo.java */



class LoaderDemo

{

  static byte [] getBytes( String fileName )

  { java.io.ByteArrayOutputStream bytesOut = new java.io.ByteArrayOutputStream();

    int bufferForByte = 0; // -1 indicates End Of File

    try

    { java.io.BufferedInputStream bytesIn =

        new java.io.BufferedInputStream( new java.io.FileInputStream( fileName ) );

      while(true)

      { bufferForByte = bytesIn.read();

        if(bufferForByte == -1) break;

        else bytesOut.write( bufferForByte );

      }

    }catch(Exception e)

     { System.out.println( "File: " + fileName + e.toString() ); return null;

     }

    return bytesOut.toByteArray();

  }

  static Class c;



  static void main( String fileNameAndClassName[] )

                        // first class-name, second fileName without .class postfix

  { String className = fileNameAndClassName[1];

    String fileName = fileNameAndClassName[0];

    ByteArrayLoader loader = new ByteArrayLoader();

    byte [] theByteArray = getBytes( fileName );

    c = loader.transformToClassFromByteArray( null, c, theByteArray );

                                           // or className instead of null

    try{ ((Thread)c.newInstance()).start(); }    // class of type Thread expected

    catch( Exception e ){ e.printStackTrace(); } // ALL PURPOSE CATCH

} }






/*
[localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% javac LoaderDemo.java
[localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% java LoaderDemo HelloWorldThread.class HelloWorldThread
byte-array to runtime-representation of class
HelloWorldThread
java.lang.IllegalAccessException
        at java.lang.reflect.Method.invoke(Native Method)
        at HelloWorldThread.run(HelloWorldThread.java:8)
[localhost:~/JavaCodeFiles/JRESecurity/JREClassLoading] andreadipietro% 
*/

/*
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/JREClassLoading > javac LoaderDemo.java
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/JREClassLoading > java LoaderDemo HelloWorldThread.class HelloWorldThread
byte-array to runtime-representation of class
HelloWorldThread
java.lang.IllegalAccessException
        at java.lang.reflect.Method.invoke(Native Method)
        at HelloWorldThread.run(HelloWorldThread.java:8)
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/JREClassLoading >
*/

/*
C:\JavaCodeFiles\JRESecurity\JREClassLoading>javac LoaderDemo.java

C:\JavaCodeFiles\JRESecurity\JREClassLoading>java  LoaderDemo HelloWorldThread.class HelloWorldThread
byte-array to runtime-representation of class
HelloWorldThread
java.lang.IllegalAccessException
        at java.lang.reflect.Method.invoke(Native Method)
        at HelloWorldThread.run(HelloWorldThread.java:7)

C:\JavaCodeFiles\JRESecurity\JREClassLoading>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






