class SignThisFile

{ public static void main( String fileName[] ) throws Exception

  { String nameOfFileToBeSigned = fileName[0];



// ----------------------------------------------------------------- Generate a key-pair.

    java.security.KeyPairGenerator theKeyGenerator =

      java.security.KeyPairGenerator.getInstance( "DSA", "SUN" );

    java.security.SecureRandom random =

      java.security.SecureRandom.getInstance( "SHA1PRNG", "SUN" );

    theKeyGenerator.initialize( 1024, random );

    java.security.KeyPair theKeyPair = theKeyGenerator.generateKeyPair();

    java.security.PrivateKey thePrivateKey = theKeyPair.getPrivate();

    java.security.PublicKey thePublicKey = theKeyPair.getPublic();



// --------- Instantiate a Signature engine-object and initialize it with the private key.

    java.security.Signature signingEngineDSA =

      java.security.Signature.getInstance( "SHA1withDSA", "SUN" );

    signingEngineDSA.initSign( thePrivateKey );



// -----------------------------------------Read in a file as a buffered stream of bytes;

//      choose the size of the buffer to be the same as the size of a cryptographic-block.

    java.io.FileInputStream fis = new java.io.FileInputStream( nameOfFileToBeSigned );

    java.io.BufferedInputStream bufis = new java.io.BufferedInputStream( fis );

    byte[] miniBuffer = new byte[1024];

    int howFull;

    while( bufis.available() != 0 )

    { howFull = bufis.read( miniBuffer );

      signingEngineDSA.update( miniBuffer, 0, howFull );

    }

    bufis.close();



// ----------------- All data has been processed by the engine; now generate a signature:

    byte[] binarySignatureDSA = signingEngineDSA.sign();



// ---------------------------------- Save the signature in a file named signatureDSA:

    java.io.FileOutputStream fos =

      new java.io.FileOutputStream( nameOfFileToBeSigned + "SignatureDSA" );

    fos.write( binarySignatureDSA );

    fos.close();



// -----------------------------------------------------Save the public key in a file.

    byte[] binaryOfEncodedPublicKey = thePublicKey.getEncoded();

    java.io.FileOutputStream keyfos =

      new java.io.FileOutputStream( nameOfFileToBeSigned + "PublicKeyDSA" );

    keyfos.write( binaryOfEncodedPublicKey );

    keyfos.close();

} }

/*

------------------ The output are two additional files placed in the current directory:

INFORMATION.txtsignatureDSA

INFORMATION.txtPublicKeyDSA

All three files together, including INFORMATION.txt

have to be transferred for authentification elsewhere.

*/








/*
[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] andreadipietro% javac SignThisFile.java
[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] andreadipietro% java SignThisFile INFORMATION.txt
[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] andreadipietro%
*/

/*
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/DataCodingSecurity > javac SignThisFile.java
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/DataCodingSecurity > java SignThisFile INFORMATION.txt
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/DataCodingSecurity >
*/

/*
C:\JavaCodeFiles\JRESecurity\DataCodingSecurity>javac SignThisFile.java

C:\JavaCodeFiles\JRESecurity\DataCodingSecurity>java  SignThisFile INFORMATION.txt

C:\JavaCodeFiles\JRESecurity\DataCodingSecurity>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






