// needs package javax.crypto
package ROTProviderPackage;
public class ROTCipher extends javax.crypto.CipherSpi
{ byte shift;
  public int engineGetBlockSize(){ return 1; } // block-size is one byte since ASCII code and not Unicode is used
  public int engineGetOutputSize( int inputSizeOfDataInBytes ){ return inputSizeOfDataInBytes; } // since block-size is 1byte
  public java.security.AlgorithmParameters engineGetParameters(){ return null; }
  public byte[] engineGetIV(){ return null; } // IV=Initialization Vector here not used
  public void engineSetPadding( String padding ) throws javax.crypto.NoSuchPaddingException
  { throw new javax.crypto.NoSuchPaddingException( "BlockSize=1, so no padding needed" ); }
  public void engineSetMode( String mode ) throws java.security.NoSuchAlgorithmException
  { throw new java.security.NoSuchAlgorithmException( "No modes needed in ROT" ); }
  public void engineInit( int i, java.security.Key aKey ) throws java.security.InvalidKeyException
  { boolean encrypt = i == javax.crypto.Cipher.ENCRYPT_MODE;
    boolean definedCryptMode = encrypt | ( i == javax.crypto.Cipher.DECRYPT_MODE );
    if(aKey instanceof ROTKey & definedCryptMode )
    { byte sign;
      if( encrypt ) sign = 1; else sign = -1;
      shift = (byte)( sign * aKey.getEncoded()[0] );
    }
    else throw new java.security.InvalidKeyException("Please, ROTKey for ROTCipher or undefined cryptMode.");
  }
  public byte[] engineUpdate( byte input[], int offset, int length )
  { return engineDoFinal( input, offset, length ); }
  public int engineUpdate( byte input[], int inOffset, int length, byte output[], int outOffset )
  { int clear, crypt = 0;
    for( int i = 0; i < length; i++)
    { clear = input[ inOffset + i ];
      if( (clear >= 'A') && (clear <= 'Z')) crypt = ( (clear - 'A' + shift) % 26) + 'A';
      if( (clear >= 'a') && (clear <= 'z')) crypt = ( (clear - 'a' + shift) % 26) + 'a';
      output[ outOffset + i ] = (byte)crypt;
    }
    return length;
  }
  public byte[] engineDoFinal( byte input[], int offset, int length )
  { byte finalOutput[] = new byte[ length - offset ];
    engineUpdate( input, offset, length, finalOutput, 0);
    return finalOutput;
  }
  public int engineDoFinal( byte input[], int inOffset, int length, byte finalOutput[], int outOffset )
  { return engineUpdate( input, inOffset, length, finalOutput, outOffset );
  }
  public void engineInit( int i,
                          java.security.Key aKey,
                          java.security.SecureRandom sr
                        ) throws java.security.InvalidKeyException
  { engineInit( i, aKey ); }
  public void engineInit( int i,
                          java.security.Key aKey,
                          java.security.AlgorithmParameters parameters,
                          java.security.SecureRandom sr
                        ) throws java.security.InvalidKeyException
  { engineInit( i, aKey ); }
  public void engineInit( int i,
                          java.security.Key aKey,
                          java.security.spec.AlgorithmParameterSpec spec,
                          java.security.SecureRandom sr
                        ) throws java.security.InvalidKeyException
  { engineInit( i, aKey ); }
}
/* Since no constructors have been defined, there exists the default constructor without arguments.
   If constructors had been defined, the should be one without arguments among them,
   otherewise a newInstance()-call from the JRE might cause trouble.
*/

/*
[localhost:JRESecurity/DataCodingSecurity/ROTProviderPackage] andreadipietro% javac *.java
[localhost:JRESecurity/DataCodingSecurity/ROTProviderPackage] andreadipietro%
*/


/*
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/DataCodingSecurity > javac ROTProviderPackage/*.java
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/DataCodingSecurity >
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */








