/* (1) NEEDS package javax.crypto
*/
/* (2) NEEDS custom written package ROTProviderPackage
   Since this source-code contains NO direct reference to identifiers of this supporting package,
   the classes of that package are NOT automatically compiled!
   Thus they have to be compiled previously and explicitly! SEE the file ROTCipher.java
*/
/* (3) To be fully functional the security provider had to be registered by SUN, since this is not the case,
   the source-code can be verified only as being compileable, the code is NOT RUNNABLE!!
*/
import ROTProviderPackage.*;  //11111111111111111 no direct reference no automatic compilation

class DemoProvider extends java.security.Provider
{ public DemoProvider()
  { super("ROTProviderPackage", 0.0, "demonstation of a provider");  //222222222222222222
    put("KeyGenerator.ROT", "ROTProviderPackage.ROTKeyGenerator");
    put("Cipher.ROT",       "ROTProviderPackage.ROTCipher"); /* put(  engineName.algorithmName  ,    ClassExtendsEngineNameSpi )
    --- engineName: general type of service like Signature, MessageDigest ... 
    --- ClassExtendsEngineNameSpi: fully-qualified name of class that actually implements an algorithm for that engine/service
    --- algorithmName: name of the implemented algorithm like "DiffieHelman", "DES", ...
 */     
} }

class ROTEncryption2
{ public static void main( String unused[] ) throws Exception
  {
// Provider, SecretKeyFactory, Cipher
    DemoProvider theDemoProvider = new DemoProvider();
    java.security.Security.insertProviderAt( theDemoProvider, 1 );        //java.security.Security.addProvider( theDemoProvider );
    java.security.Provider p =  java.security.Security.getProvider("ROTProviderPackage");
    p.list(System.out);

// To list all providers use the code of ListAvailableEngines.java
    System.out.println( "getting KeyGenerator ..." );    javax.crypto.KeyGenerator kg = javax.crypto.KeyGenerator.getInstance("ROT", "ROTProviderPackage"); 
    javax.crypto.SecretKey key = kg.generateKey();
System.out.println( "getting Cipher ..." );    javax.crypto.Cipher c = javax.crypto.Cipher.getInstance("ROT");
// Encryption
    c.init( javax.crypto.Cipher.ENCRYPT_MODE, key );
    byte inputData[] = "THIS IS TO BE KEPT SECRET".getBytes();
    byte encryptedData[] = c.doFinal( inputData );
    System.out.print( "encryption finished: " + new String( encryptedData, 0, encryptedData.length ) );
// Decryption
    c.init( javax.crypto.Cipher.DECRYPT_MODE, key );
    byte outputData[] = c.doFinal( encryptedData );
    System.out.println("Decrypted: " + new String( outputData ) );
} }
class ROTParameterSpec implements java.security.spec.KeySpec
{ byte shift;
  public ROTParameterSpec( byte shift ){ this.shift = shift; }
  public byte getShift(){ return shift; }
}
/*
[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] williammartin% java ROTEncryption2
...
Exception in thread "main" java.security.NoSuchAlgorithmException: Algorithm ROT not available
        at javax.crypto.b.a([DashoPro-V1.2-120198])
        at javax.crypto.KeyGenerator.getInstance([DashoPro-V1.2-120198])
        at ROTEncryption2.main(ROTEncryption2.java:15)
[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] williammartin%
reason unproper package placement (no expilcit reference to package member makes no automatic compilation, 
here the package has to compiled independently) 

Exception in thread "main" java.security.NoSuchProviderException: JCE cannot authenticate the provider ROTProviderPackage java.lang.SecurityException: Cannot authenticate jar:file:/Users/williammartin/JavaCodeFiles/JRESecurity/DataCodingSecurity/!/java.security.PrivilegedActionException <<java.util.zip.ZipException: error in opening zip file>>
        at javax.crypto.b.c([DashoPro-V1.2-120198])
        at javax.crypto.b.a([DashoPro-V1.2-120198])
        at javax.crypto.KeyGenerator.getInstance([DashoPro-V1.2-120198])
        at ROTEncryption2.main(ROTEncryption2.java:30)
[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] williammartin% 
reason above

[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] williammartin% javac ROTEncryption2.java
*/


/*
williammartin@linux:~/JavaCodeFiles/JRESecurity/DataCodingSecurity > javac ROTEncryption2.java
williammartin@linux:~/JavaCodeFiles/JRESecurity/DataCodingSecurity > java ROTEncryption2
-- listing properties --
KeyGenerator.ROT=ROTProviderPackage.ROTKeyGenerator
Cipher.ROT=ROTProviderPackage.ROTCipher
getting KeyGenerator ...
Exception in thread "main" java.security.NoSuchProviderException: JCE cannot authenticate the provider ROTProviderPackage java.lang.SecurityException: Cannot authenticate jar:file:/home/williammartin/JavaCodeFiles/JRESecurity/DataCodingSecurity/!/java.security.PrivilegedActionException <<java.util.zip.ZipException: Ist ein Verzeichnis>>
        at javax.crypto.b.c([DashoPro-V1.2-120198])
        at javax.crypto.b.a([DashoPro-V1.2-120198])
        at javax.crypto.KeyGenerator.getInstance([DashoPro-V1.2-120198])
        at ROTEncryption2.main(ROTEncryption2.java:28)
williammartin@linux:~/JavaCodeFiles/JRESecurity/DataCodingSecurity >

*/

/*
C:\JavaCodeFiles\JRESecurity\DataCodingSecurity>javac ROTEncryption2.java

C:\JavaCodeFiles\JRESecurity\DataCodingSecurity>java  ROTEncryption2
-- listing properties --
KeyGenerator.ROT=ROTProviderPackage.ROTKeyGenerator
Cipher.ROT=ROTProviderPackage.ROTCipher
getting KeyGenerator ...
Exception in thread "main" java.security.NoSuchProviderException: JCE cannot aut
henticate the provider ROTProviderPackage java.lang.SecurityException: Cannot au
thenticate jar:file:/C:/JavaCodeFiles/JRESecurity/DataCodingSecurity/!/java.secu
rity.PrivilegedActionException <<java.util.zip.ZipException: Access denied>>
        at javax.crypto.b.c([DashoPro-V1.2-120198])
        at javax.crypto.b.a([DashoPro-V1.2-120198])
        at javax.crypto.KeyGenerator.getInstance([DashoPro-V1.2-120198])
        at ROTEncryption2.main(ROTEncryption2.java:34)

C:\JavaCodeFiles\JRESecurity\DataCodingSecurity>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






