/*  SEE ALSO the text-file INFORMATION.txt

AuthenticateSignedData.class needs the file-name of the

                                                      1. encoded public key

                                                      2. signature

                                                      3. data thus signed

*/

class AuthenticateSignedData

{ public static void main( String threeInputData[] ) throws Exception

  { String fileNameOfEncodedPublicKey = threeInputData[0];

    String fileNameOfSignature = threeInputData[1];

    String fileNameOfData = threeInputData[2];



// --------------------------------------------- Read in binaries of encoded public key:

    java.io.FileInputStream fisKey =

                             new java.io.FileInputStream( fileNameOfEncodedPublicKey );

    byte[] binaryOfEncodedKey = new byte[ fisKey.available() ];

    fisKey.read( binaryOfEncodedKey );

    fisKey.close();



// -----------------------------------------------------------------------------------

// Create a public key with the KeyFactory engine and the Encoding specification class.

    java.security.spec.X509EncodedKeySpec defaultSpecificationOfPublicKeys =

                    new java.security.spec.X509EncodedKeySpec( binaryOfEncodedKey );

    java.security.KeyFactory keyFactory =

                               java.security.KeyFactory.getInstance( "DSA", "SUN" );

    java.security.PublicKey thePublicKey =

                      keyFactory.generatePublic( defaultSpecificationOfPublicKeys );



// ----------------------------------------- Read in the binaries of a signature-file

// (this signature should authenticate the data-file):

    java.io.FileInputStream fisSign = new java.io.FileInputStream( fileNameOfSignature );

    byte[] binarySignatureOfData = new byte[ fisSign.available() ];

    fisSign.read( binarySignatureOfData );

    fisSign.close();



// ------------------- Create a Signature-object and initialize it with the public key.

    java.security.Signature signingEngine =

                        java.security.Signature.getInstance( "SHA1withDSA", "SUN" );

    signingEngine.initVerify( thePublicKey );



// ------------------------------------------------------- Update and verify the data.

    java.io.FileInputStream fisData = new java.io.FileInputStream( fileNameOfData );

    java.io.BufferedInputStream bufis = new java.io.BufferedInputStream( fisData );

    byte[] miniBuffer = new byte[1024];

    int howFull;

    while( bufis.available() != 0 )

    { howFull = bufis.read( miniBuffer );

      signingEngine.update( miniBuffer, 0, howFull );

    };

    bufis.close();

    boolean authentic = signingEngine.verify( binarySignatureOfData );

    System.out.println( "data autenticated: " + authentic );

} }






/*
(PREREQUISITE)
[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] andreadipietro% javac SignThisFile.java
[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] andreadipietro% java SignThisFile INFORMATION.txt

[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] andreadipietro% javac AuthenticateSignedData.java
[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] andreadipietro% java AuthenticateSignedData INFORMATION.txtPublicKeyDSA INFORMATION.txtSignatureDSA INFORMATION.txt 
data autenticated: true
[localhost:~/JavaCodeFiles/JRESecurity/DataCodingSecurity] andreadipietro% 
*/


/*
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/DataCodingSecurity > java AuthenticateSignedData INFORMATION.txtPublicKeyDSA INFORMATION.txtSignatureDSA INFORMATION.txt
data autenticated: true
andreadipietro@linux:~/JavaCodeFiles/JRESecurity/DataCodingSecurity >
*/

/*
C:\JavaCodeFiles\JRESecurity\DataCodingSecurity>javac AuthenticateSignedData.java

C:\JavaCodeFiles\JRESecurity\DataCodingSecurity>java AuthenticateSignedData INFORMATION.txtPublicKeyDSA INFORMATION.txtSignatureDSA INFORMATION.txt
data autenticated: true

C:\JavaCodeFiles\JRESecurity\DataCodingSecurity>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






