public class WhoIs

{ final static int WHO_IS_PORT = 43;

  final static String WHO_IS_HOST = "rs.internic.net";

  /* The European region is serviced by whois.ripe.net,

     more of this can be found in www.internic.net.

   */



  static java.net.Socket whoIsTCPSocket;

  static java.io.DataInputStream whoIsInputStream;    // <<<<<

  static java.io.DataOutputStream whoIsOutputStream; // >>>>>



public static void main( String [] potentialDomainName )

  { if( potentialDomainName.length != 1 )

    { System.out.println("enter domainname"); System.exit(-1);}

    try

    { whoIsTCPSocket = new java.net.Socket( WHO_IS_HOST, WHO_IS_PORT );

      whoIsOutputStream =

        new java.io.DataOutputStream( whoIsTCPSocket.getOutputStream() );  // >>>>>

      whoIsInputStream =

        new java.io.DataInputStream( whoIsTCPSocket.getInputStream() );    // <<<<<

      whoIsOutputStream.writeBytes( potentialDomainName[0] + "\r\n" );

      // the above line sends the question to the WhoIs-server.

      try

      { do

        { byte s = whoIsInputStream.readByte(); // receives answer from WhoIs-server

          System.out.print( (char)s );

        }while( true );

      }catch( java.io.EOFException e )          // an exception ends the WhoIs reply

       { System.out.println(">>>> End of File <<<<<"); }

      whoIsTCPSocket.close();

    }

    catch( java.io.IOException e ){ e.printStackTrace(); }

} }

/* www.dns.net informs on how domain-names and IP-addresses are resolved technically

   by name-servers like DNSAUTH1.SYS.GTEI.NET

*/

 


/*
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] marycosway% javac WhoIs.java
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] marycosway% java WhoIs cnn.com
java.net.UnknownHostException: rs.internic.net
        at java.net.InetAddress.getAllByName0(InetAddress.java:571)
        at java.net.InetAddress.getAllByName0(InetAddress.java:540)
        at java.net.InetAddress.getByName(InetAddress.java:449)
        at java.net.Socket.<init>(Socket.java:100)
        at WhoIs.main(WhoIs.java:11)
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] marycosway% java WhoIs cnn.com

Whois Server Version 1.3

Domain names in the .com, .net, and .org domains can now be registered
with many different competing registrars. Go to http://www.internic.net
for detailed information.

   Domain Name: CNN.COM
   Registrar: NETWORK SOLUTIONS, INC.
   Whois Server: whois.networksolutions.com
   Referral URL: http://www.networksolutions.com
   Name Server: NS-01A.ANS.NET
   Name Server: NS-01B.ANS.NET
   Name Server: NS-02A.ANS.NET
   Name Server: NS-02B.ANS.NET
   Updated Date: 13-jun-2001


>>> Last update of whois database: Thu, 5 Jul 2001 01:56:47 EDT <<<

The Registry database contains ONLY .COM, .NET, .ORG, .EDU domains and
Registrars.

>>>> End of File <<<<<
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] marycosway%


[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] marycosway% java WhoIs javasoft.com

Whois Server Version 1.3

Domain names in the .com, .net, and .org domains can now be registered
with many different competing registrars. Go to http://www.internic.net
for detailed information.

   Domain Name: JAVASOFT.COM
   Registrar: NETWORK SOLUTIONS, INC.
   Whois Server: whois.networksolutions.com
   Referral URL: http://www.networksolutions.com
   Name Server: NS.JAVASOFT.COM
   Name Server: DNSAUTH1.SYS.GTEI.NET
   Name Server: DNSAUTH2.SYS.GTEI.NET
   Name Server: DNSAUTH3.SYS.GTEI.NET
   Updated Date: 13-jun-2001


>>> Last update of whois database: Thu, 5 Jul 2001 01:56:47 EDT <<<

The Registry database contains ONLY .COM, .NET, .ORG, .EDU domains and
Registrars.

>>>> End of File <<<<<
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] marycosway%
*/





/*
(Whois informas only about registered top-level-domains, not subdomains, to get a result try below 'berkeley.edu':)
marycosway@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol > java WhoIs setiathome.ssl.berkeley.edu

Whois Server Version 1.3

Domain names in the .com, .net, and .org domains can now be registered
with many different competing registrars. Go to http://www.internic.net
for detailed information.

No match for "SETIATHOME.SSL.BERKELEY.EDU".

>>> Last update of whois database: Tue, 31 Jul 2001 02:02:11 EDT <<<

The Registry database contains ONLY .COM, .NET, .ORG, .EDU domains and
Registrars.

>>>> End of File <<<<<
marycosway@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol >
*/






/*
C:\JavaCodeFiles\CommunicatingComputers\InternetProtocol>javac WhoIs.java

C:\JavaCodeFiles\CommunicatingComputers\InternetProtocol>java  WhoIs berkeley.edu
java.net.UnknownHostException: rs.internic.net
        at java.net.InetAddress.getAllByName0(Unknown Source)
        at java.net.InetAddress.getAllByName0(Unknown Source)
        at java.net.InetAddress.getByName(Unknown Source)
        at java.net.Socket.<init>(Unknown Source)
        at WhoIs.main(WhoIs.java:11)

C:\JavaCodeFiles\CommunicatingComputers\InternetProtocol>java  WhoIs berkeley.edu

Whois Server Version 1.3

Domain names in the .com, .net, and .org domains can now be registered
with many different competing registrars. Go to http://www.internic.net
for detailed information.

   Domain Name: BERKELEY.EDU
   Registrar: NETWORK SOLUTIONS, INC.
   Whois Server: whois.networksolutions.com
   Referral URL: http://www.networksolutions.com
   Name Server: NS2.BERKELEY.EDU
   Name Server: NS2.ZOCALO.NET
   Name Server: PHLOEM.UOREGON.EDU
   Name Server: NS1.BERKELEY.EDU
   Name Server: VANGOGH.CS.BERKELEY.EDU
   Name Server: UCSFNS1.UCSF.EDU
   Name Server: DNS2.UCLA.EDU
   Updated Date: 13-jun-2001


>>> Last update of whois database: Mon, 13 Aug 2001 02:05:19 EDT <<<

The Registry database contains ONLY .COM, .NET, .ORG, .EDU domains and
Registrars.

>>>> End of File <<<<<

C:\JavaCodeFiles\CommunicatingComputers\InternetProtocol>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






