class URLMechanisms implements java.net.URLStreamHandlerFactory, java.net.ContentHandlerFactory

{ public static void main( String uniformResourceLocator[] ) throws Exception

  { URLMechanisms x = new URLMechanisms();

    java.net.URL.setURLStreamHandlerFactory( x );

    // the method-call above signalizes the system where to search for a create...()-method (***)

    java.net.URLConnection.setContentHandlerFactory( x );

    java.net.URL url = new java.net.URL( uniformResourceLocator[0] );

    java.io.BufferedReader br;

    try                                                                          // (+++default:)

    { br = new java.io.BufferedReader(

                           new java.io.InputStreamReader( (java.io.InputStream)url.getContent() ) );

    }catch( java.lang.ClassCastException e )

    { br = (java.io.BufferedReader)url.getContent(); }                      // (+++defined below)

/* the try-catch-clause could be avoided

   --- by letting the getContent()-method below return an InputStream or

   --- by analyzing the returned entity of type Object with the

       java.lang.reflect package and choosing a method of processing.

*/

    String s;

    do

    { s = br.readLine();

      if(s == null) break;                  // finish if StringBuffer is empty

      if(s.trim().length() == 0) continue;  // print no empty lines

      System.out.println(s);

    }while(true);

  }

/* This is the end of the regular program;

   this regular program also works with the default settings,

   which become active if the first three lines of the main()-methods are outcommented.

   The code below implements service-modules which have been introduced by calling

   the x-argumented methods above.

*/

// (***) create...()-methods tell the system from where to take the service-modules.



/* Here the service-modules are introduced as being simple class-files,

   given by the source-code below.

*/

  // Below define a triggerable method, during URL instantiation

  public java.net.URLStreamHandler createURLStreamHandler( String protocol )

  {

   //protocol = protocol.toLowerCase();

   // URL returns String-reference to protocol anyway in lower-case!

    try

    { Class urlStreamHandlerName = Class.forName( protocol + "URLStreamHandler" );

      Object o = urlStreamHandlerName.newInstance(); // creation = instantiation

      return ( java.net.URLStreamHandler )o;

    }catch( Exception e ){ e.printStackTrace(); return null; }

  }



  // Triggerable method, during URL instantiation.

  // Called by URLConnection.getContentHandler(String contentType) (default or convention)

  public java.net.ContentHandler createContentHandler( String contentType )

  { try

    { Class urlStreamHandlerName = Class.forName( contentType + "ContentHandler" );

      Object o = urlStreamHandlerName.newInstance(); // creation = instantiation

      return ( java.net.ContentHandler )o;

    }catch( Exception e ){ e.printStackTrace(); return null; }

} }



/*

the various service-modules to which the create...()-methods refer

*/

class httpURLStreamHandler extends java.net.URLStreamHandler

// lower-case because URL returns String-reference to protocol in lower-case!

{ protected java.net.URLConnection openConnection( java.net.URL url ) throws java.io.IOException

  { return new httpURLConnection( url ); } // see below...

}

class httpURLConnection extends java.net.URLConnection

{ final static char defaultPort = 80; // default port of HTTProtocol

  java.net.URL url;

  java.io.PrintWriter textOutputStream;

  java.io.InputStream inputStream; // own identifier for use by getInputStream()-method

  java.io.BufferedReader textInputStream, contentIn;

  boolean headerStatesHtml = false;

  public httpURLConnection( java.net.URL url )

  { super( url ); // necessary because URLConnection has no standard constructor

    this.url = url;

  }

  public void connect() throws java.io.IOException // contains HTTP-mechanisms

  { if( !connected ) // variable taken from java.net.URLConnection

    { char port;

      int potentialPort = url.getPort(); // if -1 then default port

      if( potentialPort > 0 && potentialPort < 65535 ) port = (char)potentialPort;

      else port = defaultPort;

// socket and streams

      java.net.Socket socket = new java.net.Socket( url.getHost(), port );

      java.io.OutputStream outputStream = socket.getOutputStream();

      textOutputStream =

        new java.io.PrintWriter( new java.io.OutputStreamWriter( outputStream, "8859_1" ), true );

      inputStream = socket.getInputStream();

      textInputStream =

        new java.io.BufferedReader( new java.io.InputStreamReader( inputStream, "8859_1" ) );

// get header and analyze header

      textOutputStream.println( "HEAD " + url.getFile() + " HTTP/1.0\r\n\r\n");

      String s; int headerLength = 2; // last linefeed

      while(  ( s = textInputStream.readLine() ).length() != 0  )

      { headerLength = headerLength + s.length() + 2; // 2 for \r\n line endings

        java.util.StringTokenizer st = new java.util.StringTokenizer(s);

        String firstToken  = st.nextToken().toLowerCase();

        String secondToken = st.nextToken().toLowerCase();

        if( ( firstToken.startsWith( "content-type" ) && secondToken.startsWith( "text/html" ) )

          ){ headerStatesHtml = true; }

      } // textOutputStream.close(); textInputStream.close(); socket.close(); // no difference

// 2nd socket needed because of HTTP1.0, this shouldn't be needed in HTTP1.1

      if( headerStatesHtml == true )

      {

        java.net.Socket socket2 = new java.net.Socket( url.getHost(), port );

        textOutputStream = new java.io.PrintWriter

        ( new java.io.OutputStreamWriter( socket2.getOutputStream(), "8859_1" ), true );

        inputStream = socket2.getInputStream();

        textOutputStream.println( "GET " + url.getFile() + " HTTP/1.0\r\n\r\n" );

        for( int i = 0; i < headerLength; i++ ) { inputStream.read(); };

        connected = true;

      }else{ throw new java.io.IOException( "No HTML-file" ); }

  } }

  public java.io.InputStream getInputStream() throws java.io.IOException

  { if( !connected ) connect();

    return inputStream;

  }

  public String getContentType()

  { try

    { if( !connected ) connect();

      if( headerStatesHtml == true ) { return "html"; }

      else { System.out.println( "getContentType returns null" ); return null; }

    }catch( Exception e ){ e.printStackTrace(); return null; }

  } // used by this class's getContent()-method

// protected void finalize() throws java.io.IOException{ textOutputStream.close(); httpRawIn.close(); }

// This closes the socket.

}





// ---- here the HTML-tags are extracted for a plain-text version without hyperlinks ----



class htmlContentHandler extends java.net.ContentHandler

{

  // (+++) automatically called by method java.net.URL.getContent()

  public Object getContent( java.net.URLConnection urlConnection )

  { try

    { java.io.InputStream is = urlConnection.getInputStream();

      java.io.InputStreamReader ris = new java.io.InputStreamReader( is );

      HTMLCommandFilter fris = new HTMLCommandFilter( ris );

      java.io.BufferedReader bris = new java.io.BufferedReader( fris );

      return bris;

    }catch( Exception e ){ e.printStackTrace(); return null; } // extract content and transform it

} }



/* How to archive pure relaying action by the getContent( java.net.URLConnection )-method?

   Just outcomment everything within its try-clause, except the first line

   java.io.InputStream is = urlConnection.getInputStream();

   and change the last, then second line to

   return is;

   To follow the program run, intersperse a System.out.println();

   at the beginning of every method-call.

*/

class HTMLCommandFilter extends java.io.FilterReader

{ HTMLCommandFilter( java.io.Reader in ){ super( in ); }

  boolean transfer = true;

  char character;

  public int read() throws java.io.IOException

  { char c = (char)in.read();

    if( c == '<' ) { transfer = false; return 0; }

    if( c == '>' ) { transfer = true; return 0; }

    if( transfer == true ) return (int)c; else return 0;

  }

  public int read( char[] c ) throws java.io.IOException

  { int len;

    len = in.read(c, 0, c.length);

    return len;

  }

  public int read( char[] c, int off, int len ) throws java.io.IOException

  { len = in.read(c, off, len);

    for( int i = 0; i < len; i++ )

    { character = (char)c[i];

      if( character == '<' ){ transfer = false; c[i] = 0; }

      if( character == '>' ){ transfer = true; c[i] = 0; }

      if( transfer != true ) c[i] = 0;

    }

    return len;

} }







/*
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] andreadipietro% javac URLMechanisms.java
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] andreadipietro% java URLMechanisms http://www.w3.org/
The World Wide Web Consortium
Leading the Web to its Full
Potential...
Activities | Technical&#160;Reports | Site&#160;Index | About&#160;W3C | Contact
The World Wide Web Consortium (W3C) develops
interoperable technologies (specifications, guidelines, software, and
...
Keio), All Rights Reserved. W3C liability, trademark, document
use and software licensing rules
apply. Your interactions with this site are in accordance with our public and Member privacy
statements.
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] andreadipietro%
*/




/*
(The code above has difficulties working with subdomains:)
andreadipietro@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol > javac URLMechanisms.java
andreadipietro@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol > java URLMechanisms http://setiathome.ssl.berkeley.edu
Exception in thread "main" java.net.UnknownHostException: setiathome.ssl.berkeley.edu
        at java.net.InetAddress.getAllByName0(InetAddress.java:571)
        at java.net.InetAddress.getAllByName0(InetAddress.java:540)
        at java.net.InetAddress.getByName(InetAddress.java:449)
        at java.net.Socket.<init>(Socket.java:100)
        at httpURLConnection.connect(URLMechanisms.java:78)
        at httpURLConnection.getInputStream(URLMechanisms.java:106)
        at java.net.URLConnection.getContent(URLConnection.java:558)
        at java.net.URL.getContent(URL.java:812)
        at URLMechanisms.main(URLMechanisms.java:10)
andreadipietro@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol >
*/





/*
C:\JavaCodeFiles\CommunicatingComputers\InternetProtocol>javac URLMechanisms.java

C:\JavaCodeFiles\CommunicatingComputers\InternetProtocol>java URLMechanisms http://www.w3.org/
 .........  Keio    ), All Rights Reserved. W3C
                                            liability    ,
                                trademark    ,
                              document
use     and                                                               softwa
re licensing     rules
apply. Your interactions with this site are in accordance with our
                                       public     and
                           Member     privacy
statements.

C:\JavaCodeFiles\CommunicatingComputers\InternetProtocol>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






