/* The class UDPSocket has a main()-method.

That method instantiates an UDP-socket-, a sender- and an receiver-object.

The sender sends a single packet out into the network.

The receiver lets a while-loop listen for arriving packets.

This program requires a working counterpart on some other host in the (local) network.

*/

class UDPSocket extends java.net.DatagramSocket

{

  UDPSocket( char udpPort ) throws java.net.SocketException

  { super( udpPort );

    System.out.println("socket opened");

  }

  // No IP-address because UDP is a connectionless protocol, IP-address only in datagram!


  public static void main( String IPaddressOfDestination[] )

  { char udpPort = 1025;

    try

    { UDPSocket udpSocket = new UDPSocket( udpPort );

      new UDPSender                                        // SENDER established

      ( udpSocket, java.net.InetAddress.getByName( IPaddressOfDestination[0] ), udpPort );

      new UDPReceiver( udpSocket );// RECEIVER established

    }catch( Exception e ){ e.printStackTrace(); }          // ALL PURPOSE CATCH

} }



class UDPSender

{ UDPSender( UDPSocket udpSocket, java.net.InetAddress drainIPAddress, char drainUdpPort )

  { String message = new String( "A string message over udp" );

    byte[] byteArray = new byte[ message.length() ];

    byteArray = message.getBytes();

    // here only low order byte of each (two byte) character in String

    // otherwise use the String-method 'getChars()' and a double length array

    java.net.DatagramPacket udpPacket =     ////////////////////////////////// THE PACKET

new java.net.DatagramPacket( byteArray, byteArray.length, drainIPAddress, drainUdpPort );

    try

    { udpSocket.send( udpPacket ); //// the trigger for sending the UDP-packet ------>

      System.out.println( "A packet has been sent." );

    }catch( Exception e ){ e.printStackTrace(); }          // ALL PURPOSE CATCH

} }



class UDPReceiver

{ UDPReceiver( UDPSocket udpSocket )

  { byte [] buffer = new byte [65535];

                          // actually only needed: 2^16 minus IP-Header minus UDPHeader

    java.net.DatagramPacket udpPacket =

                                  new java.net.DatagramPacket( buffer, buffer.length );

    while(true)

    { try

      { udpSocket.receive( udpPacket );// blocks, stops until new message is received <-

        System.out.println( new String( udpPacket.getData() ) +

                            " from " + udpPacket.getAddress() +

                            " at port no. " + udpPacket.getPort()

                           );

      }catch( Exception e ){ e.printStackTrace(); }

} } }

/* No client, no server because contact is not initiated by anyone,

   therefore sender and receiver denotations have been used.

*/











/* no client, no server because contact is not initiated by anyone,
therefore  sender and receiver denotations have been used
*/
// Sender- and receiver-parts can be threaded to send and receive independently
/* The two computers have to be connected by networking hardware. In both operating systems,
   the TCP/IP control windows have to be properly configured,
   giving one computer the local IP-address
   Terminal input of computer1 (192.168.0.1):
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] vincent% javac UDPSocket.java
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] vincent% java UDPSocket 192.168.0.2
A packet has been sent. (packet is lost if computer2 has not been started)
A string message over udp from 192.168.0.2/192.168.0.2 at port no. 1025 (received AFTER starting computer2!)

   Terminal input of computer2 (192.168.0.2):
jerome@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol > javac UDPSocket.java
jerome@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol > java UDPSocket 192.168.0.1
A packet has been sent.

Restarting the program on each computer resends the message.
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






