/* Processes only requests of the form

"GET http://<host> <optionalPortNumber> <pathWithSlashSeparators> HTTP1.1"

*/

class HTTPServer

{ static char tcpPortNum = (char)1025;

  public static void main( String unused[] ) throws java.io.IOException

  { java.net.ServerSocket ss = new java.net.ServerSocket( tcpPortNum );

    java.net.Socket cs;

    while(true)

    { cs = ss.accept(); // server-socket only needed to accept the connection

      new Thread( new ServerThread( cs ) ).start();

} } }



class ServerThread implements Runnable

{ java.net.Socket cs;

  ServerThread( java.net.Socket cs ){ this.cs = cs; }

  public void finalize() throws java.io.IOException{ cs.close(); }

  public void run()

  { try

    { java.io.InputStream tcpIn = cs.getInputStream();

      java.io.OutputStream tcpOut = cs.getOutputStream();

      new HTTPCommunicate( tcpIn, tcpOut );

    }catch( java.io.IOException e ){ e.printStackTrace(); }

} }



class HTTPCommunicate

{ HTTPCommunicate( java.io.InputStream tcpIn, java.io.OutputStream tcpOut ) throws java.io.IOException

  { java.io.BufferedReader stringsIn =

    new java.io.BufferedReader( new java.io.InputStreamReader( tcpIn ) );



    String clientCall = stringsIn.readLine();

    System.out.println( "HTTP request: " + clientCall );

    String uriString = clientCall.substring( 3, clientCall.length() - 8 );

    // cuts out "GET" cuts out " HTTP1.1"

    System.out.println( "uriString: " + uriString );

    java.util.StringTokenizer uriTokens = new java.util.StringTokenizer( uriString, "/" );

    String protocol = uriTokens.nextToken();

    String hostPort = uriTokens.nextToken();

    String nonPath = protocol + "://" + hostPort;

    String path = uriString.substring( nonPath.length() ).trim();

    System.out.println( "path: " + path );



    java.io.FileInputStream fileIn = new java.io.FileInputStream( path );

    byte [] fileBytes = new byte[ fileIn.available() ];

    fileIn.read( fileBytes );



    //java.io.BufferedWriter stringsOut =  // NOT NEEDED if file small enough

    //new java.io.BufferedWriter( new java.io.OutputStreamWriter( tcpOut ) );



    tcpOut.write( fileBytes );

    tcpOut.close(); // without close the client may get hooked

} }





/*
marycosway@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol > javac HTTPServer.java
marycosway@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol > java HTTPServer
HTTP request: GET http://192.168.0.1:1025/HTTPServer.java HTTP1.1
uriString:  http://192.168.0.1:1025/HTTPServer.java
path: HTTPServer.java
Client request: GET http://192.168.0.1:1025/HTTPClient.java HTTP1.1
uriString:  http://192.168.0.1:1025/HTTPClient.java
path: HTTPClient.java

marycosway@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol >
*/



/*
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] marycosway% javac HTTPServer.java
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] marycosway% java HTTPServer
HTTP request: GET http://192.168.0.5:1025/HTTPServer.java HTTP1.1
uriString:  http://192.168.0.5:1025/HTTPServer.java
path: HTTPServer.java
Client request: GET http://192.168.0.5:1025/HTTPClient.java HTTP1.1
uriString:  http://192.168.0.1:1025/HTTPClient.java
path: HTTPClient.java
^C
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] marycosway% java HTTPServer
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */







