/*

input format:

java HTTPClient (calls http://www.w3.org/) OR

java HTTPClient <host> <port> <path>

*/

class HTTPClient

{

  public static void main( String hostPortPath[] ) throws Exception

  {

    String host = null;

    String path = null;

    int port = 80; // default port for http-service

    if( hostPortPath.length != 3 )

    {  host = "www.w3.org"; path = "/"; }

    else

    { host = hostPortPath[0]; port = Integer.parseInt( hostPortPath[1] );

      path = hostPortPath[2];

    }

    java.net.Socket socket = new java.net.Socket( host, port );  // IP-level

    java.io.OutputStream out = socket.getOutputStream();         // TCP-level

    java.io.InputStream in = socket.getInputStream();            // HTTP-level

    // HTTP-level, command-string below:

    out.write( ( new String( "GET " + "http://" + host + ":" +

                             port + path + " HTTP1.1\r\n\r\n" ) ).getBytes() );

    out.flush();

    int intUsedAsByte;

    while( ( intUsedAsByte = in.read() ) != -1 )

    { System.out.write( intUsedAsByte );

} } }






/*
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] andreadipietro% javac HTTPClient.java
(needs a working Internet-connection otherwise throws a java.net.UnknownHostException: www.w3.org)
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] andreadipietro% java HTTPClient
HTTP/1.1 200 OK
Date: Mon, 09 Jul 2001 14:42:10 GMT
Server: Apache/1.3.6 (Unix) PHP/3.0.15
Content-Location: Overview.html
Opt: "http://www.w3.org/2000/P3Pv1";ns=11
...
</body>
</html>

(needs a working local IP-network otherwise throws a java.net.ConnectException: Operation timed out)
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] andreadipietro% java HTTPClient 192.168.0.1 80 /
HTTP/1.1 200 OK
Date: Mon, 09 Jul 2001 14:32:55 GMT
Server: Apache/1.3.19 (Unix)  (SuSE/Linux) mod_layout/1.0 mod_throttle/3.0 mod_fastcgi/2.2.2 mod_perl/1.25 mod_dtcl
Content-Location: index.html.en
Vary: negotiate,accept-language
TCN: choice
Connection: close
Content-Type: text/html
Content-Language: en
Expires: Mon, 09 Jul 2001 14:32:55 GMT

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<HTML>
<HEAD>
..
</BODY>
</HTML>


[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] andreadipietro% java HTTPClient 192.168.0.1 1025 /HTTPServer.java
class HTTPServer
{ static char tcpPortNum = (char)1025;
  public static void main( String unused[] ) throws java.io.IOException
...
[localhost:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol] andreadipietro%
*/





/*
andreadipietro@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol > javac HTTPClient.java
andreadipietro@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol > java HTTPClient
HTTP/1.1 200 OK
Date: Tue, 31 Jul 2001 09:42:21 GMT
Server: Apache/1.3.6 (Unix) PHP/3.0.11
Opt: "http://www.w3.org/2000/P3Pv1";ns=11
11-PolicyRef: /2000/06/P3P/p3p_www.xml
Cache-Control: max-age=600
Expires: Tue, 31 Jul 2001 09:52:21 GMT
Last-Modified: Fri, 27 Jul 2001 16:58:39 GMT
ETag: "4857b-4897-3b619dbf"
Accept-Ranges: bytes
Content-Length: 18583
Connection: close
Content-Type: text/html; charset=us-ascii

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US"
lang="en-US">

</html>


andreadipietro@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol >

(the output depends heavily on the format of the downloaded text-file, below the output with linefeeds ignored:)
andreadipietro@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol > java HTTPClient 192.168.0.5 1025 /HTTPServer.java
andreadipietro@linux:~/JavaCodeFiles/Communicatandreadipietro@linux:~/JavaCodeFiles/CommunicatingComputers/InternetProtocol >
*/





/*
C:\JavaCodeFiles\CommunicatingComputers\InternetProtocol>javac HTTPClient.java 
C:\JavaCodeFiles\CommunicatingComputers\InternetProtocol>java HTTPClient http://www.gamelan.com
.....
</table>

<hr class="hide" />
<div class="banner"><a class="bannerLink"
href="Consortium/Activities">Activities</a> | <a class="bannerLink"
href="TR/">Technical&#160;Reports</a> | <a class="bannerLink"
href="Help/siteindex">Site&#160;Index</a> | <a class="bannerLink"
href="Consortium/">About&#160;W3C</a> | <a class="bannerLink"
href="Consortium/Contact">Contact</a></div>

<p><a href="http://lists.w3.org/Archives/Public/site-comments/">Send
comments about this page</a>.</p>

<address><a href="Help/Webmaster">Webmaster</a> &#183; Last modified:
$Date: 2001/08/11 00:33:58 $<br />
 <a href="http://validator.w3.org/"><img src="/Icons/valid-xhtml10"
alt="Valid XHTML 1.0!" height="31" width="88" border="0" /></a> <a
href="http://jigsaw.w3.org/css-validator/"><img src="/Icons/valid-css"
alt="Valid CSS1!" height="31" width="88" border="0" /></a> <a
href="WAI/WCAG1AA-Conformance"
title="Explanation of Level Double-A Conformance"><img class="conform"
height="32" width="88" border="0" src="/WAI/wcag1AA"
alt="Level Double-A conformance icon, W3C-WAI Web Content Accessibility Guidelin
es 1.0" /></a></address>

<p class="copyright"><a rel="Copyright"
href="Consortium/Legal/ipr-notice#Copyright"><br />
Copyright</a> &#169; 1994-2001 <a href="/"><acronym
title="World Wide Web Consortium">W3C</acronym></a><sup>&#174;</sup>
(<a href="http://www.lcs.mit.edu/"><acronym
title="Massachusetts Institute of Technology">MIT</acronym></a>, <a
href="http://www.inria.fr/"><acronym xml:lang="fr" lang="fr"
title="Institut National de Recherche en Informatique et Automatique">INRIA</acr
onym></a>,
<a href="http://www.keio.ac.jp/">Keio</a>), All Rights Reserved. W3C <a
href="Consortium/Legal/ipr-notice#Legal_Disclaimer">liability</a>, <a
href="Consortium/Legal/ipr-notice#W3C_Trademarks">trademark</a>, <a
rel="Copyright" href="Consortium/Legal/copyright-documents">document
use</a> and <a rel="Copyright"
href="Consortium/Legal/copyright-software">software licensing</a> rules
apply. Your interactions with this site are in accordance with our <a
href="Consortium/Legal/privacy-statement#Public">public</a> and <a
href="Consortium/Legal/privacy-statement#Members">Member</a> privacy
statements.</p>
</body>
</html>



C:\JavaCodeFiles\CommunicatingComputers\InternetProtocol>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */







