/* main()-method in class FilterStream */

/* First introduce a custom-written stream:

   --- to change or to establish the stream's functionality override the read()-methods

       according to the convention specified in the documentation

       of the java.io.FilterReader-class, or on page [ConventionFilterStreamClass].

       See for (*) in this piece of source-code.

*/

/*

This programs has five options for reading from an input-stream:

1. read directly from input-stream

2. read from a filter, a sieve, wrapped around the input-stream (finds character 'e')

3. delayed, read from buffered output, wrapped around the input-stream

4. delayed, read from sieve, wrapped around the input-stream (finds character 'e')

5. delayed, read from buffered sieve, wrapped around the input-stream (finds character 'e')

*/

class SieveReader extends java.io.FilterReader

{ char mesh;

  public SieveReader( char m, java.io.Reader r)

  { super(r); mesh = m;

  } // if super(r) is outcommented, 'cannot resolve symbol' error at compile-time

  public int read() throws java.io.IOException  // (*)

  { int i = super.read();

    if( i == (int)mesh )

    { report( "\nfound " + mesh + " with read() " ); return 0; } // omit mesh-character

    else return i; // returns Unicode-number of character read (*)

  }

  public int read( char[] charray ) throws java.io.IOException  // (*)

  { return read( charray, 0, charray.length );

  }

  public int read( char[] charray, int offset, int length )

  throws java.io.IOException  // (*)

  { report( "\n array[0.." + charray.length + "]" );

    super.read( charray, offset, length );  // reads in the data!

    return analyze( charray ); // method returns number of characters read (*)

  }

  private int analyze( char charray[] )

  { for( int i = 0; i < charray.length; i++ )

    { System.out.print( charray[ i ] );

      if( charray[i] == 0 ) break;

               // above: end of data, substitutes the function InputStream.available()

      if( charray[i] == mesh )

         report( "\nfound  " + mesh + " from read(.) at position " + i );

      charray[i] = 0;  // omit

    }

    return charray.length; // method returns number of characters read (*)

  }

  private void report( String s ){ System.out.print( s ); }

/* public void close() throws java.io.IOException{ super.close(); }

   would be necessary if abstract Java.io.Reader was extended;

   unnecessary with non-abstract java.io.FilterReader

*/

}

class FilterStream

{ private static int counter = 0;

  private static void listArray( char array[] )

  { for( int c = 0; c < array.length; c++) System.out.print( array[c] );

  }

  public static void main( String integer[] )

  { int source;

    char mesh = 'e';

    char array[] = new char[1024];

                /* default length of array, may be substituted by buffered streams,

               /  conveniently chosen to be a power of the number '2' usually 1024.

              / The length of the array determines the size of the

             / data packets attempted to be read from the stream.

           */

    try

    { java.io.PipedWriter charOut = new java.io.PipedWriter();

// connect two half pipes to a pipe:

      java.io.PipedReader charIn =  new java.io.PipedReader( charOut );

// and continue wrapping streams:

      SieveReader sieve = new SieveReader ( mesh, charIn );

      java.io.BufferedReader bufferedSieve = new java.io.BufferedReader( sieve );

/*

 * The following branch does not imply that reading

 * can be done from both branches at the same time,

 * otherwise one branch looses information to the other!

 */

      java.io.BufferedReader bufferedCharIn = new java.io.BufferedReader( charIn );

// Action:

      while( true )   // a continuous stream of characters

      { source = (int)( 33+93*Math.random() );

        counter++;

//        if( counter == 5000 ) charOut.close();

//        above: throws exception in the 5000th cycle

        charOut.write( source ); // range 33 .. 126

        switch( Integer.parseInt( integer[0] ) )

        { case 1: System.out.print("[" + counter + " " + (char)source + "> " );

                  System.out.print( " >" + (char)charIn.read() + "] " ); break;

// tests the immediate echo thus does not block

          case 2: System.out.print("[" + counter + " " + (char)source + "> " );

                  System.out.print( " >" + (char)sieve.read() + "] " ); break;

          case 3: System.out.print("[" + counter + " " + (char)source + "> " );

                  if( counter%100 == 0 )

                  { System.out.println( " read buf>> " +

                                           bufferedCharIn.read(array) + ": " );

                    listArray( array ); System.out.print( " ] " );

                  } break;

          case 4: if( counter%100 == 0 )

                  System.out.print( "\n" + counter + " read sieve>>" +

                                            sieve.read(array) + "] " ); break;

          case 5: if( counter%100 == 0 )

                  System.out.print

                  ( "\n" + counter + " read sievebuf>> " +

                                    bufferedSieve.read(array) + "] " ); break;

        } // case

      } // while

    }catch(java.io.IOException e){ e.printStackTrace(); }

     //catch( Exception e ){ e.printStackTrace(); }

} }











/*
andreadipietro@linux:~/JavaCodeFiles/Basics2/StreamsPipes > java FilterStream 2
[1 U>  >U] ...  [84 a>  >a] [85 e>
found e with read()  >] [86 >>  >>] ....


andreadipietro@linux:~/JavaCodeFiles/Basics2/StreamsPipes > java FilterStream 3
[1 ,> [2 L> [3 &> [4 %> .... [97 X> [98 a> [99 `> [100 <>  read buf>> 100:
,L&%NSm@EY'p^W-Z1PxG,T[r=kBu{zoR%-p3"[-*h!9A8"6_z63$XB>N2*Ai!^!<aOPt<$liTAbZ.f'KY={oB5He^PH=0[<|Xa`< ] [101 ->
[102 {> [103 s> [104 {> ....


andreadipietro@linux:~/JavaCodeFiles/Basics2/StreamsPipes > java FilterStream 4

 array[0..1024](#==r68MHnMHnl9qm(,/9K]?f9t`O/@|{%viXRs|tQc@x;#)+W4Xx%oJuO|<^X%;kWLbKe
found  e from read(.) at position 69z6/]a/$<0JQNh`I!jc;_>`r?6=`KEs
100 read  sieve>>1024]
 array[0..1024]LBO)A?]{8NMDxswX'A)BPf>d.<d,UjJSPMgg+{]4N)xp/M+H)VoD;}6Grhi#F1kmU.t0nwdjdr>61o<x(3J&imK57?tR\"Bm2#jZ
200 read  sieve>>1024]
 array[0..1024],J8WUB,SjqLQOMSd8n$Vv9uks-BW882fYk](z8jyEN=OXO>mz*Kh{-51nZ2SqY$Ywd5BA/+K'e
found  e from read(.) at position 732VK@v.6c^z}WH&RxN.bw/.!,A7
300 read  sieve>>1024]
 array[0..1024]sRwstsD[Fc:IwW=QVJ'!e
found  e from read(.) at position 20@OaCa%mPxqg{t"*Q#MbTY")#P>Tv$e
found  e from read(.) at position 50%`F\P5x'O`Ee
found  e from read(.) at position 62n);@K}c06cGi9OJ^ghhA=!x?<;If^==v3mxES
400 ....

andreadipietro@linux:~/JavaCodeFiles/Basics2/StreamsPipes > java FilterStream 5

 array[0..8192]B-ESdF9_e
found  e from read(.) at position 8"3ke
found  e from read(.) at position 12K/P5kIhY90Y^ZP,'80LUk_kzL4q;h9g,>)1DCiBY?b=x{e
found  e from read(.) at position 58x4KRy/s?$^TOHCnU<e
found  e from read(.) at position 76pe
found  e from read(.) at position 78ZCPDn?e
found  e from read(.) at position 85)d\Wmr>$Mmu_Ed
100 read  sievebuf>> 1024]
200 read  sievebuf>> 1024]
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






