/* Enter an arbitrary number of integers

   if one of them is smaller than 7, then the assignment is stopped and reverted.

*/

/* An instance of type java.beans.VetoableChangeSupport

   provides a method fireVetoableChange():

   1. When the programmer calls the method in the source-code,

   this triggers the dispatch of references of type VetoableChangeEvent

   to all the registered listeners

   (bean[j].vetoRegistry.addVetoableChangeListener( bean[ k ] );).

   2. Successively each single listener runs the code inside

   the handler-method vetoableChange().

   3. If one listener throws a java.beans.PropertyVetoException,

   the fire..()-method catches it and refires it,

   containing the old property-value, to all listeners.

   4. Thus all changes are reverted.

   5. Finally the fire..()-method rethrows the java.beans.PropertyVetoException.

*/

import java.beans.VetoableChangeSupport;

import java.beans.VetoableChangeListener;

import java.beans.PropertyVetoException;

import java.beans.PropertyChangeEvent;



class BeanVeto implements java.io.Serializable, VetoableChangeListener

{

  private int numberOfBean, maximum;

  public int getNo(){ return numberOfBean; }



  VetoableChangeSupport vetoRegistry;

  BeanVeto( int tag, int defaultPropertyValue, int upperLimit )

  { numberOfBean = tag; vetoableProperty = defaultPropertyValue; maximum = upperLimit;

    vetoRegistry = new VetoableChangeSupport( this );

  }



  private int vetoableProperty; // ---------------------------------------- the value



                                    // ---------------------------------------- set...

  public void setVetoableProperty( int candidate ) throws PropertyVetoException

  {

    int old = vetoableProperty;

    vetoRegistry.fireVetoableChange

    ( "the Vetoable Property", new Integer( old ), new Integer( candidate )

    );

    vetoableProperty = candidate; // ---- PROPERTY-CHANGE, if no VETO has been thrown!

    System.out.println

    ( "vetoable property of Bean no." + this.getNo() +

                                         " changes from " + old + " to " + candidate );

  }

  public int getVetoableProperty(){ return vetoableProperty; } // ------------- get...



// -------------------------------- implementing the interface VetoableChangeListener:

  public void vetoableChange( PropertyChangeEvent e ) throws PropertyVetoException

  {

    int candidate = ((Integer)e.getNewValue()).intValue();

    // work with candidate, any VETO will revert this by rethrowing a reverting event

    System.out.println

    ( "\nHANDLER of Bean no." + this.getNo() +

      " with propertyValue " + vetoableProperty +

      " received candidate " + candidate + " < " + maximum + "? else throw exception "

    );

    if( candidate > maximum)

    { System.out.println("Exception to be produced");

      // ----------------- V E T O if suggested change exceeds the given maximal value!

      throw

      new PropertyVetoException

      ( "Bean no." + this.getNo() +

                           " vetoes because  " + candidate + " > " + maximum, e );

    }

    System.out.println

    ( "This Bean allows: " + e.getPropertyName() +

      " of Bean no." + ((BeanVeto)e.getSource()).numberOfBean +

      " has permission to be changed!" + " Works with: " + candidate

    );

  }



  public static void main( String upperLimit[] ) throws PropertyVetoException

  {

    int n = upperLimit.length;

    BeanVeto bean[] = new BeanVeto[n];

    for( int i = 0; i < n; i++ )

    { bean[i] =

new BeanVeto(i, -i-300, Integer.parseInt( upperLimit[i] ) ); } //// revert-values ////

    for( int j = 0; j < n; j++ )

      for( int k = 0; k < n; k++)

      { bean[j].vetoRegistry.addVetoableChangeListener( bean[ k ] );

        //System.out.println( j + " " + k ); // (k+j+1)%n

      }

    try{ bean[0].setVetoableProperty( 7 ); }                   ////// maximum ///////

    catch( PropertyVetoException e )

    { System.out.println(e.getMessage() +

                          " thus reverting the value of the property of bean[0].");

    }

    // ----------------------------------------- some drain-Bean has thrown a V E T O

} }




/*
[localhost:~/JavaCodeFiles/Basics2/CSSoftwareComponents] marycosway% javac BeanVeto.java
[localhost:~/JavaCodeFiles/Basics2/CSSoftwareComponents] marycosway% java BeanVeto 12 5 34

HANDLER of bean no.0 with propertyValue -300 received candidate 7 < 12? else throw exception
This bean allows: the Vetoable Property of bean no.0 has permission to be changed! Works with: 7

HANDLER of bean no.1 with propertyValue -301 received candidate 7 < 5? else throw exception 
Exeption to be produced

HANDLER of bean no.0 with propertyValue -300 received candidate -300 < 12? else throw exception
This bean allows: the Vetoable Property of bean no.0 has permission to be changed! Works with: -300

HANDLER of bean no.1 with propertyValue -301 received candidate -300 < 5? else throw exception 
This bean allows: the Vetoable Property of bean no.0 has permission to be changed! Works with: -300

HANDLER of bean no.2 with propertyValue -302 received candidate -300 < 34? else throw exception
This bean allows: the Vetoable Property of bean no.0 has permission to be changed! Works with: -300
bean no.1 vetoes because  7 > 5 thus reverting the value of the property of bean[0].
[localhost:~/JavaCodeFiles/Basics2/CSSoftwareComponents] marycosway%
*/



/*
marycosway@linux:~/JavaCodeFiles/Basics2/CSSoftwareComponents > javac BeanVeto.java
marycosway@linux:~/JavaCodeFiles/Basics2/CSSoftwareComponents > java BeanVeto 45 78 56

HANDLER of bean no.0 with propertyValue -300 received candidate 7 < 45? else throw exception
This bean allows: the Vetoable Property of bean no.0 has permission to be changed! Works with: 7

HANDLER of bean no.1 with propertyValue -301 received candidate 7 < 78? else throw exception
This bean allows: the Vetoable Property of bean no.0 has permission to be changed! Works with: 7

HANDLER of bean no.2 with propertyValue -302 received candidate 7 < 56? else throw exception
This bean allows: the Vetoable Property of bean no.0 has permission to be changed! Works with: 7
vetoable property of bean no.0 changes from -300 to 7
marycosway@linux:~/JavaCodeFiles/Basics2/CSSoftwareComponents >
*/




/*
C:\JavaCodeFiles\Basics2\CSSoftwareComponents>javac BeanVeto.java

C:\JavaCodeFiles\Basics2\CSSoftwareComponents>java BeanVeto 12 5 34

HANDLER of bean no.0 with propertyValue -300 received candidate 7 < 12? else throw exception
This bean allows: the Vetoable Property of bean no.0 has permission to be changed! Works with: 7

HANDLER of bean no.1 with propertyValue -301 received candidate 7 < 5? else throw exception
Exeption to be produced

HANDLER of bean no.0 with propertyValue -300 received candidate -300 < 12? else throw exception
This bean allows: the Vetoable Property of bean no.0 has permission to be changed! Works with: -300

HANDLER of bean no.1 with propertyValue -301 received candidate -300 < 5? else throw exception
This bean allows: the Vetoable Property of bean no.0 has permission to be changed! Works with: -300

HANDLER of bean no.2 with propertyValue -302 received candidate -300 < 34? else throw exception
This bean allows: the Vetoable Property of bean no.0 has permission to be changed! Works with: -300
bean no.1 vetoes because  7 > 5 thus reverting the value of the property of bean[0].

C:\JavaCodeFiles\Basics2\CSSoftwareComponents>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */







