// informs listener Bean-objects of state-changes

import java.beans.PropertyChangeSupport;

import java.beans.PropertyChangeListener;

import java.beans.PropertyChangeEvent;



class BeanBound implements java.io.Serializable, PropertyChangeListener

{

  int numberOfBean;

  public int getNo(){ return numberOfBean; }



  PropertyChangeSupport changeRegistry;

// constructor and registering facility supplying a method addPropertyChangeListener():

  BeanBound( int number )

  { numberOfBean = number;

    changeRegistry = new PropertyChangeSupport( this );

  }



  int boundProperty; // ---------------------------------------------------- the value



  public void setBoundProperty( int newInt ) // ---------------------------- set...

{           // set... changes property and notifies listeners

    int old = boundProperty;

    boundProperty = newInt;

    changeRegistry.firePropertyChange(

                       "the Bound Property", new Integer(old), new Integer(newInt ) );

  }

  public int getBoundProperty(){ return boundProperty; } // ---------------- get...



 // ------------------------------- implementing the interface PropertyChangeListener:

// -------------------------------- means defining the handler of change notification:

  public void propertyChange( PropertyChangeEvent e )

  { System.out.println( "Bean No."+ this.getNo() + " knows: " + e.getPropertyName() +

    " of Bean no." + ((BeanBound)e.getSource()).numberOfBean + " has changed!" );

  }

  public static void main( String unused[] )

  {

    int n = 5; // choose n larger than 2

    BeanBound bean[] = new BeanBound[n];

    for( int i = 0; i < n; i++ ){ bean[i] = new BeanBound(i);}

    for( int j = 0; j < n; j++ )

      for( int k = 0; k < n; k++)

      { bean[j].changeRegistry.addPropertyChangeListener( bean[k] );

        // System.out.println( j + " " + k );

      }

    bean[1].setBoundProperty( 10 );

} }

 



/*
[localhost:~/JavaCodeFiles/Basics2/CSSoftwareComponents] marycosway% javac BeanBound.java
[localhost:~/JavaCodeFiles/Basics2/CSSoftwareComponents] marycosway% java BeanBound
Bean No.0 knows: the Bound Property of bean no.1 has changed!
Bean No.1 knows: the Bound Property of bean no.1 has changed!  (<- self notification)
Bean No.2 knows: the Bound Property of bean no.1 has changed!
Bean No.3 knows: the Bound Property of bean no.1 has changed!
Bean No.4 knows: the Bound Property of bean no.1 has changed!
[localhost:~/JavaCodeFiles/Basics2/CSSoftwareComponents] marycosway%
*/


/*
marycosway@linux:~/JavaCodeFiles/Basics2/CSSoftwareComponents > javac BeanBound.java
marycosway@linux:~/JavaCodeFiles/Basics2/CSSoftwareComponents > java BeanBound
Bean No.0 knows: the Bound Property of bean no.1 has changed!
Bean No.1 knows: the Bound Property of bean no.1 has changed!
Bean No.2 knows: the Bound Property of bean no.1 has changed!
Bean No.3 knows: the Bound Property of bean no.1 has changed!
Bean No.4 knows: the Bound Property of bean no.1 has changed!
marycosway@linux:~/JavaCodeFiles/Basics2/CSSoftwareComponents >
*/


/*
C:\JavaCodeFiles\Basics2\CSSoftwareComponents>javac BeanBound.java

C:\JavaCodeFiles\Basics2\CSSoftwareComponents>java BeanBound
Bean No.0 knows: the Bound Property of bean no.1 has changed!
Bean No.1 knows: the Bound Property of bean no.1 has changed!
Bean No.2 knows: the Bound Property of bean no.1 has changed!
Bean No.3 knows: the Bound Property of bean no.1 has changed!
Bean No.4 knows: the Bound Property of bean no.1 has changed!

C:\JavaCodeFiles\Basics2\CSSoftwareComponents>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






