/* A Producer sends strings to a Consumer by calling notifyObservers() */



class Out{ Out( String s ){ System.out.println( s ); } }



class Producer extends java.util.Observable

{ public void setChanged(){ super.setChanged(); }

  // this makes protected setChanged()-method accessible publicly

}

class Consumer implements java.util.Observer // requires update()-method

{

  public void update( java.util.Observable observed, Object messageObject )

  { new Out( this.toString() + " got " + messageObject + " from " + observed );

} }

class ObservableObserver

{ public static void main( String unused[] )

  { Producer source = new Producer();

    Consumer firstDrain = new Consumer();

    Consumer secondDrain = new Consumer();

    new Out( "number of observers " + source.countObservers() );

    source.addObserver( firstDrain );

    source.addObserver( secondDrain );

    new Out( "number of observers " + source.countObservers() );

    source.notifyObservers( "a first String object as message" ); // lost

    new Out( "hasChanged? " + source.hasChanged() );

    source.setChanged(); new Out( "hasChanged? " + source.hasChanged() );

    source.notifyObservers( "a second String object as message" );

    source.deleteObservers();

    new Out( "number of observers " + source.countObservers() );

} }

/* Why is setChanged() redeclared 'public' in Producer-class?

The inherited method produces a 'method has protected access' compile-time error

in the main()-method when calling source.setChanged().

The class ObservableObserver is not a sub-class of Observable

and therefore the protected method setChanged() cannot be invoked!

*/

 



/*
[localhost:~/JavaCodeFiles/Basics2/CSMessaging] andreadipietro% javac ObservableObserver.java
[localhost:~/JavaCodeFiles/Basics2/CSMessaging] andreadipietro% java ObservableObserver
number of observers 0
number of observers 2
hasChanged? false
hasChanged? true
Consumer@30c19b got a second String object as message from Producer@76a7b9
Consumer@7d772e got a second String object as message from Producer@76a7b9
number of observers 0
[localhost:~/JavaCodeFiles/Basics2/CSMessaging] andreadipietro%
*/

/*
andreadipietro@linux:~/JavaCodeFiles/Basics2/CSMessaging > javac ObservableObserver.java
andreadipietro@linux:~/JavaCodeFiles/Basics2/CSMessaging > java ObservableObserver
number of observers 0
number of observers 2
hasChanged? false
hasChanged? true
Consumer@7a78d3 got a second String object as message from Producer@129206
Consumer@30f13d got a second String object as message from Producer@129206
number of observers 0
andreadipietro@linux:~/JavaCodeFiles/Basics2/CSMessaging >
*/

/*
C:\JavaCodeFiles\Basics2\CSMessaging>javac ObservableObserver.java

C:\JavaCodeFiles\Basics2\CSMessaging>java ObservableObserver
number of observers 0
number of observers 2
hasChanged? false
hasChanged? true
Consumer@47e553 got a second String object as message from Producer@20c10f
Consumer@62eec8 got a second String object as message from Producer@20c10f
number of observers 0

C:\JavaCodeFiles\Basics2\CSMessaging>
*/




/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






