/* the pure event-throwing infrastructure (could be substituted by a simple method-call) */

class Out{ Out( String s ){ System.out.println( s ); } }



class Event extends java.util.EventObject

{ Event(Object source)

  { super(source);

    new Out( "4. Source: Event-object instantiated" );

} }



interface EventListener extends java.util.EventListener

{ void handleEvent( Event evt );

}



class Source

{ Source(){ new Out( "1. Source instantiated" ); }

  EventListener listener;

  void addEventListener( EventListener l ) // called by drain -- links source to drain

  { listener = l;

    new Out( "3. Drain calls: source.addEventListener establishes link (The Call)" );

  }

  void removeEventListener( EventListener l ){ listener = null; }

  void activateTheSourceObject()

  { Event THEeVENToBJECT = new Event(this); // event-object instantiated

    new Out(

       "5. Source dispatches MESSAGE: calls now (registered) listener (The Callback)" );

    listener.handleEvent(THEeVENToBJECT); // central message transfer by method-call <===

    new Out( "7. Source finished" );

} }



class Drain implements EventListener

{ Drain( Source source)

  { new Out(

         "2. Drain instantiated, registers as event-listener and furnishes handlers" );

    source.addEventListener( this );

  }

  public void handleEvent( Event evt ) // event-handler is required to be public

  { new Out( "6. Drain: Message received (and handled)" );

} }



class EventMechanism

{ public static void main( String unused[] )

  { Source theSource = new Source();

    Drain theDrain = new Drain( theSource );

    theSource.activateTheSourceObject();

    theSource.removeEventListener( theDrain );

    theSource.activateTheSourceObject(); // null-pointer exception

} }







/*
[localhost:~/JavaCodeFiles/Basics2/CSMessaging] marycosway% javac EventMechanism.java
[localhost:~/JavaCodeFiles/Basics2/CSMessaging] marycosway% java EventMechanism
1. Source instantiated
2. Drain instantiated, registers as event-listener and furnishes handlers
3. Drain calls: source.addEventListener establishes link (The Call)
4. Source: Event-object instantiated
5. Source dispatches MESSAGE: calls now (registered) listener (The Callback)
6. Drain: Message received (and handled)
7. Source finished
4. Source: Event-object instantiated
5. Source dispatches MESSAGE: calls now (registered) listener (The Callback)
Exception in thread "main" java.lang.NullPointerException
        at Source.activateTheSourceObject(EventMechanism.java:24)
        at EventMechanism.main(EventMechanism.java:43)
[localhost:~/JavaCodeFiles/Basics2/CSMessaging] marycosway%
*/


/*
marycosway@linux:~/JavaCodeFiles/Basics2/CSMessaging > javac EventMechanism.java
marycosway@linux:~/JavaCodeFiles/Basics2/CSMessaging > java EventMechanism
1. Source instantiated
2. Drain instantiated, registers as event-listener and furnishes handlers
3. Drain calls: source.addEventListener establishes link (The Call)
4. Source: Event-object instantiated
5. Source dispatches MESSAGE: calls now (registered) listener (The Callback)
6. Drain: Message received (and handled)
7. Source finished
4. Source: Event-object instantiated
5. Source dispatches MESSAGE: calls now (registered) listener (The Callback)
Exception in thread "main" java.lang.NullPointerException
        at Source.activateTheSourceObject(EventMechanism.java:24)
        at EventMechanism.main(EventMechanism.java:43)
marycosway@linux:~/JavaCodeFiles/Basics2/CSMessaging >
*/


/*
C:\JavaCodeFiles\Basics2\CSMessaging>javac EventMechanism.java

C:\JavaCodeFiles\Basics2\CSMessaging>java EventMechanism
1. Source instantiated
2. Drain instantiated, registers as event-listener and furnishes handlers
3. Drain calls: source.addEventListener establishes link (The Call)
4. Source: Event-object instantiated
5. Source dispatches MESSAGE: calls now (registered) listener (The Callback)
6. Drain: Message received (and handled)
7. Source finished
4. Source: Event-object instantiated
5. Source dispatches MESSAGE: calls now (registered) listener (The Callback)
Exception in thread "main" java.lang.NullPointerException
        at Source.activateTheSourceObject(EventMechanism.java:25)
        at EventMechanism.main(EventMechanism.java:44)

C:\JavaCodeFiles\Basics2\CSMessaging>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






