/**
--- DOCUMENTATION COMMENTS begin with '/**'.
/**

--- DOCUMENTATION COMMENTS begin with "/**".

--- Documentation comments FACE THE DEFINITIONS of:

    classes, interfaces, members(methods and variables)

--- SPECIAL TAGS prefixed by the at-symbol "@"

    contain additional information or even links

    in the remaining part of the line:

    @author Andrea di Pietro (This tag followed by the author's name

                              is used only in class or interface documentation comments.)

    @version 1.0 (This tag followed by a version-code

                  is used only for classes or interfaces.)

*/

public class DocumentedHelloWorld

{ /** A four-byte class-variable of type integer. */

  static int i;

   /** A method that maybe used by existing code, but shouldn't

       be used by newly written code.

       The "@deprecated" tag marks only such classes and members.

       @deprecated */

   void oldVersion(){}

   /** Only for methods are meant the three tags "@param", "@return" and "@exception".

       @param      parameters of the method, here none.

       @return     returns nothing, because declared "void".

       @exception  Exception thrown by the method plus a closer description that

                   can comprise multiple lines.

       The following should generates a hyperlink

                   if the class-name is known and the API documentation

                   is in the CLASSPATH.

       @see java.lang.String

       @see java.lang.System */

  public static void main( String unused [] ) throws Exception

  { System.out.println("Documented Hello World!");

} }



/** Here the test for a simple class-structure */

class Test extends DocumentedHelloWorld

{ /** Another 32-bit integer variable, non-static */

  int j;

}



/* This generates files that can be found in the current directory

   (=directory where the source-code is to be found).

   For more see the Java Online Documentation from Sun and its tool section.

*/






/*
[localhost:~/JavaCodeFiles/Basics2/ArchiveDocument] wiliammartin% javadoc -private DocumentedHelloWorld.java
Loading source file DocumentedHelloWorld.java...
Constructing Javadoc information...
Building tree for all the packages and classes...
Building index for all the packages and classes...
Generating overview-tree.html...
Generating index-all.html...
Generating deprecated-list.html...
Building index for all classes...
Generating allclasses-frame.html...
Generating index.html...
Generating packages.html...
Generating DocumentedHelloWorld.html...
javadoc: warning - Tag @see: Class or Package not found: System
Generating Test.html...
Generating serialized-form.html...
Generating package-list...
Generating help-doc.html...
Generating stylesheet.css...
1 warning
[localhost:~/JavaCodeFiles/Basics2/ArchiveDocument] wiliammartin%
*/

/*
wiliammartin@linux:~/JavaCodeFiles/Basics2/ArchiveDocument > javadoc -private DocumentedHelloWorld.java
Loading source file DocumentedHelloWorld.java...
Constructing Javadoc information...
Building tree for all the packages and classes...
Building index for all the packages and classes...
Generating overview-tree.html...
Generating index-all.html...
Generating deprecated-list.html...
Building index for all classes...
Generating allclasses-frame.html...
Generating index.html...
Generating packages.html...
Generating DocumentedHelloWorld.html...
javadoc: warning - Tag @see: Class or Package not found: System
Generating Test.html...
Generating serialized-form.html...
Generating package-list...
Generating help-doc.html...
Generating stylesheet.css...
1 warning
wiliammartin@linux:~/JavaCodeFiles/Basics2/ArchiveDocument >


wiliammartin@linux:~/JavaCodeFiles/Basics2/ArchiveDocument > javac DocumentedHelloWorld.java
wiliammartin@linux:~/JavaCodeFiles/Basics2/ArchiveDocument > java DocumentedHelloWorld
Documented Hello World!
wiliammartin@linux:~/JavaCodeFiles/Basics2/ArchiveDocument >
*/



/*
C:\JavaCodeFiles\Basics2\ArchiveDocument>javadoc -private DocumentedHelloWorld.java
Loading source file DocumentedHelloWorld.java...
Constructing Javadoc information...
Building tree for all the packages and classes...
Building index for all the packages and classes...
Generating overview-tree.html...
Generating index-all.html...
Generating deprecated-list.html...
Building index for all classes...
Generating allclasses-frame.html...
Generating index.html...
Generating packages.html...
Generating DocumentedHelloWorld.html...
javadoc: warning - Tag @see: Class or Package not found: java.lang.System
Generating Test.html...
Generating serialized-form.html...
Generating package-list...
Generating help-doc.html...
Generating stylesheet.css...
1 warning

C:\JavaCodeFiles\Basics2\ArchiveDocument>

C:\JavaCodeFiles\Basics2\ArchiveDocument>javac DocumentedHelloWorld.java

C:\JavaCodeFiles\Basics2\ArchiveDocument>java DocumentedHelloWorld
Documented Hello World!

C:\JavaCodeFiles\Basics2\ArchiveDocument>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






