/* This piece of code does the same as the standard HelloWorld program.

   But the printing of the "Hello World!" string is encapsulated into a method. */

class HelloWorldMethod

{

  static void toEndUser( String s ) // method, output-routine, handler

  { System.out.println( s );

  }

  public static void main( String unused[] )

  { toEndUser( "Hello World!" );

  }

}

/*

Declaration, Definition of Methods:

--- The class contains two methods: The main()-method and the toEndUser()-method.

--- The main()-method takes several input-arguments indicated by [] of type String.

--- The toEndUser()-method takes only one input-argument, a variable of type String.

--- Both methods do not return any values and therefore are marked by the modifier 'void'.

Activation or Call of a method:

--- The method toEndUser() is called from inside the main()-method.

--- The main()-method is called when the end-user types

    "java HelloWorldMethod<RETURN>" into the terminal-window.

*/

/*
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway% javac HelloWorldMethod.java
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway% java HelloWorldMethod
Hello World!
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization > javac HelloWorldMethod.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization > java HelloWorldMethod
Hello World!
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization >
*/

/*
C:\JavaCodeFiles\Basics1\SCProceduralization>javac HelloWorldMethod.java

C:\JavaCodeFiles\Basics1\SCProceduralization>java HelloWorldMethod
Hello World!

C:\JavaCodeFiles\Basics1\SCProceduralization>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






