class FragmentsMethods
{
  static void methodBlock1(){ final double PI = 3.1415; }; // OR
  static void methodBlock2(){ final double PI; PI = 3.1415; }; // blank-final, assignable just once
  
  static void print(String s){ System.out.print(s); }
  static void print(String [] s){ for( int i = 0; i < s.length; i++ ) System.out.print( s[i] ); } // prints array of strings
  static void print(Object o){System.out.print(o);} // this prints everything it gets except primitive-types
// this collection of print methods prints any string-information it can get
// The argument object takes almost any variable of reference-type and prints the available information

  static void recurseTo( int depth )
  { System.out.println( "Entered level " + depth );
    if( depth < 3 ) recurseTo( depth + 1 ); // termination and recursion
    System.out.println( "Leaving level " + depth );
  }

public static void main( String unused[] )
  { 
    methodBlock1(); methodBlock2();

    print( "overloaded print" );
    String[] a = { "first element", "second element" };
    print( new String[]{ "first element", "second element" } );
    // initial call;
    recurseTo(1);

      new PairOverloadedConstructor();
      new PairOverloadedConstructor(2,3);  
  } 
}

class PairOverloadedConstructor
{ int x1, x2;  PairOverloadedConstructor(){ x1 = 0; x2 = 0; }; // default values
  PairOverloadedConstructor( int x, int y ){ x1 = x; x2 = y; }; // the constructor with two arguments for non-default cases
}
/*
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway% javac FragmentsMethods.java
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway% java FragmentsMethods
overloaded printfirst elementsecond elementEntered level 1
Entered level 2
Entered level 3
Leaving level 3
Leaving level 2
Leaving level 1
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization > javac FragmentsMethods.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization > java FragmentsMethods
overloaded printfirst elementsecond elementEntered level 1
Entered level 2
Entered level 3
Leaving level 3
Leaving level 2
Leaving level 1
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization >
*/

/*
C:\JavaCodeFiles\Basics1\SCProceduralization>javac FragmentsMethods.java

C:\JavaCodeFiles\Basics1\SCProceduralization>java FragmentsMethods
overloaded printfirst elementsecond elementEntered level 1
Entered level 2
Entered level 3
Leaving level 3
Leaving level 2
Leaving level 1

C:\JavaCodeFiles\Basics1\SCProceduralization>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






