/*

--- A method-call, with arguments given by-value, copies the data, then any

    changes to that data, inside the method, are confined to the method-block.

    (The character-value changes to 'x' only within the method.)

--- A method-call, with arguments given by-reference,

    makes the method change the original data.

    (The StringBuffer-variable changes its value also outside the method-block.)

*/

class CallsByValueByReference

{

  public static void main( String unused[] )

  {

    char byValue = 'v';

    StringBuffer byReference = new StringBuffer( "referenced" );

    // Thus, before the method-call: byValue='v' and byReference="referenced"



    theMethod( byValue, byReference );

    System.out.println( "data AFTER method-call, by-value: " + byValue +

                        " and by-reference: " + byReference );

  }



  static void theMethod( char ch, StringBuffer s )

  {

    ch = 'x';

    s.append(" and thus changed.");

    System.out.println( "data during method-call, by-value: " + ch +

                        " and by-reference: " + s );

} }



/*
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway% javac CallsByValueByReference.java
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway% java CallsByValueByReference
data during method-call, by-value: x and by-reference: referenced and thus changed.
data after method-call, by-value: v and by-reference: referenced and thus changed.
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization > javac CallsByValueByReference.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization > java CallsByValueByReference
data during method-call, by-value: x and by-reference: referenced and thus changed.
data after method-call, by-value: v and by-reference: referenced and thus changed.
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization >
*/

/*
C:\JavaCodeFiles\Basics1\SCProceduralization>javac CallsByValueByReference.java

C:\JavaCodeFiles\Basics1\SCProceduralization>java CallsByValueByReference
data during method-call, by-value: x and by-reference: referenced and thus changed.
data after method-call, by-value: v and by-reference: referenced and thus changed.

C:\JavaCodeFiles\Basics1\SCProceduralization>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






