public class Callback

{

  static void ping( int x )

  {

     System.out.println( "ping " + x );

     if( x <= 0 ) return;                                 // termination

     pong( --x );                                         // call

  }

  static void pong( int x )

  {

    System.out.println( "pong " + x );

    ping( --x );                                          // callback

  } // return NOT used here and method leaves only by calling ping()!



  public static void main( String unused[] ){ ping(5); }  // first call

}

// What happens if ping(x) or/and pong(x--) are used and why?

// Answer: Non-termination, due to non-effective change of counter!






/*
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway% javac Callback.java
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway% java Callback
ping 5
pong 4
ping 3
pong 2
ping 1
pong 0
ping -1
[localhost:~/JavaCodeFiles/Basics1/SCProceduralization] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization > javac Callback.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization > java Callback
ping 5
pong 4
ping 3
pong 2
ping 1
pong 0
ping -1
marycosway@linux:~/JavaCodeFiles/Basics1/SCProceduralization >
*/

/*
C:\JavaCodeFiles\Basics1\SCProceduralization>javac Callback.java

C:\JavaCodeFiles\Basics1\SCProceduralization>java Callback
ping 5
pong 4
ping 3
pong 2
ping 1
pong 0
ping -1

C:\JavaCodeFiles\Basics1\SCProceduralization>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






