class JavaAndHFS // (Hierarchical File System)

{ public static void main( String unused[] )

  { String path = new String

    ( System.getProperty("user.dir")

      + System.getProperty("file.separator") + "JavaAndHFS.java"

      // reconsider the output if the line above is omitted

    );

    java.io.File HFSObject = new java.io.File( path );

    System.out.println

    ( "path = " + path +

      "\nThe HFS-parent of the HFSObject is " +        HFSObject.getParent() +

      "\nThe name of the HFSObject is " +              HFSObject.getName() +

      "\nThe HFSObject a file? " +                     HFSObject.isFile() +

      "\nThe HFSObject is a directory/folder? " +      HFSObject.isDirectory() +

      "\nThe HFSObject is a path-collection? " +

                               (!HFSObject.isFile() & !HFSObject.isDirectory()) +

      "\nIs the HFSObject as path absolute? " +        HFSObject.isAbsolute() +

      "\nThe HFSObject's length in bytes " +           HFSObject.length() +

      "\nLast modified in milliseconds since 1970: " + HFSObject.lastModified() +

      "\ncan be read " +                               HFSObject.canRead() +

      "\ncan be written " +                            HFSObject.canWrite()

    );

    try

    { String [] contentHFSObject = HFSObject.list();

      for( int i = 0; i < contentHFSObject.length; i++ )

      { System.out.println( contentHFSObject[i] ); }

    }

    catch( java.lang.NullPointerException e )

    { System.out.println("A file has no string contents"); }

    // exception catching could be avoided by using a simple if-clause

} }





/*
[localhost:~/JavaCodeFiles/Basics1/SCPackaging] marycosway% javac JavaAndHFS.java
[localhost:~/JavaCodeFiles/Basics1/SCPackaging] marycosway% java JavaAndHFS
path= /Users/haiko/JavaCodeFiles/Basics1/Aggregation/JavaAndHFS.java
The HFS-parent of the HFSObject is /Users/marycosway/JavaCodeFiles/Basics1/Aggregation
The name of the HFSObject is JavaAndHFS.java
The HFSObject a file? true
The HFSObject is a directory/folder? false
The HFSObject is a path-collection? false
Is the HFSObject as path absolute? true
The HFSObject's length in bytes 1921
Last modified in milliseconds since 1970: 992354783000
can be read true
can be written true
A file has no string contents
[localhost:~/JavaCodeFiles/Basics1/SCPackaging] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/Basics1/SCPackaging > javac JavaAndHFS.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCPackaging > java JavaAndHFS
path= /home/marycosway/JavaCodeFiles/Basics1/SCPackaging/JavaAndHFS.java
The HFS-parent of the HFSObject is /home/marycosway/JavaCodeFiles/Basics1/SCPackaging
The name of the HFSObject is JavaAndHFS.java
The HFSObject a file? true
The HFSObject is a directory/folder? false
The HFSObject is a path-collection? false
Is the HFSObject as path absolute? true
The HFSObject's length in bytes 2679
Last modified in milliseconds since 1970: 996413056000
can be read true
can be written true
A file has no string contents
marycosway@linux:~/JavaCodeFiles/Basics1/SCPackaging >
*/

/*
C:\JavaCodeFiles\Basics1\SCPackaging>javac JavaAndHFS.java

C:\JavaCodeFiles\Basics1\SCPackaging>java JavaAndHFS
path= C:\JavaCodeFiles\Basics1\SCPackaging\JavaAndHFS.java
The HFS-parent of the HFSObject is C:\JavaCodeFiles\Basics1\SCPackaging
The name of the HFSObject is JavaAndHFS.java
The HFSObject a file? true
The HFSObject is a directory/folder? false
The HFSObject is a path-collection? false
Is the HFSObject as path absolute? true
The HFSObject's length in bytes 2961
Last modified in milliseconds since 1970: 997374986000
can be read true
can be written true
A file has no string contents

C:\JavaCodeFiles\Basics1\SCPackaging>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






