
class Original

{

  int aVariable;                      // instance-variable

  int aMethod(){ return aVariable; }  // instance-method

  void out( String s ){ System.out.print(s); }

}

class Extension extends Original

{

  int aVariable=10;                           // overshadows the Original variable

  int aMethod(){ return 3*aVariable; }        // overrides the Original aMethod()



  void accessFromInside(int aVariable) // argument-name overshadows the instance-variable

  { out

    (                                                                   // the variable:

 "ACCESS FROM INSIDE: Parameter of method               aVariable = "+aVariable

+"\nVariable of enclosing class                      this.aVariable = "+this.aVariable

+"\nVariable of super-class of the enclosing class  super.aVariable = "+super.aVariable

+"\n((Original)this).aVariable = " + ((Original)this).aVariable + " = super.aVariable"

                                                                        // the method:

+"\nMethod of enclosing class             aMethod() = " + aMethod()

+"\nOverridden aMethod unshadowed   super.aMethod() = " + super.aMethod()

+"\n"

    );

} }

// The code above is part of the following class "Unshadow",

// therefore these classes should be found by the Java compiler in one text-file.


// this class uses the preceding classes Original and Extension

class Unshadow

{ public static void main( String unused[] )

  {

    Original o, oo;

    Extension e, ee;

    o = new Original();

    e = new Extension();

    // ----------------------------------------------------------- NOW ACCESS FROM OUTSIDE

    o.out( "\nACCESS FROM OUTSIDE\n" );

                                  // same results with e.out( "\nACCESS FROM OUTSIDE\n" );

    ((Original)e).aVariable = 1;

              /* Access to members INside the class with 'super' and 'this',

                 from OUTside the class with casting!   */

    e.aVariable = 10;

    o.out

    (    "e.aVariable = " + e.aVariable + " is instance member"

      +"\n((Original)e).aVariable = " + ((Original)e).aVariable

                                      + " is instance member of parent, unshadowed"

      +"\ne.aMethod() = " + e.aMethod()

      +"\nbut CASTING a reference gives no access to OVERRIDDEN METHODS:"

      +"\n((Original)e).aMethod() = " + ((Original)e).aMethod()

      +"\n"

    );

    e.accessFromInside(100); // ----------------------------------- NOW ACCESS FROM INSIDE



    // -------------------------------------------- finally some possibilities for casting

    oo = (Original)e;

    ee = (Extension)oo;

    /* ee = (Extension)o;

    // throws a Runtime exception:

    // Exception in thread "main" java.lang.ClassCastException: Original at...

    */

} }



/*
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation2] marycosway% javac Unshadow.java
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation2] marycosway% java Unshadow

ACCESS FROM OUTSIDE
e.aVariable = 10 is instance member
((Original)e).aVariable = 1 is instance-member of parent, unshadowed
e.aMethod() = 30
but CASTING a reference gives no access to OVERRIDDEN METHODS:
((Original)e).aMethod() = 30

ACCESS FROM INSIDE: Parameter of method aVariable = 100
Variable of enclosing class this.aVariable = 10
Variable of super-class of the enclosing class super.aVariable = 1
((Original)this).aVariable = 1 = super.aVariable
Method of enclosing class aMethod() = 30
Overridden aMethod unshadowed super.aMethod() = 1
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation2] marycosway%
*/




/*
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation2 > javac Unshadow.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation2 > java Unshadow

ACCESS FROM OUTSIDE
e.aVariable = 10 is instance member
((Original)e).aVariable = 1 is instance member of parent, unshadowed
e.aMethod() = 30
but CASTING a reference gives no access to OVERRIDDEN METHODS:
((Original)e).aMethod() = 30

ACCESS FROM INSIDE: Parameter of method aVariable = 100
Variable of enclosing class this.aVariable = 10
Variable of super-class of the enclosing class super.aVariable = 1
((Original)this).aVariable = 1 = super.aVariable
Method of enclosing class aMethod() = 30
Overridden aMethod unshadowed super.aMethod() = 1
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation2 >
*/




/*
C:\JavaCodeFiles\Basics1\SCObjectOrientation2>javac Unshadow.java

C:\JavaCodeFiles\Basics1\SCObjectOrientation2>java Unshadow

ACCESS FROM OUTSIDE
e.aVariable = 10 is instance member
((Original)e).aVariable = 1 is instance member of parent, unshadowed
e.aMethod() = 30
but CASTING a reference gives no access to OVERRIDDEN METHODS:
((Original)e).aMethod() = 30

ACCESS FROM INSIDE: Parameter of method aVariable = 100
Variable of enclosing class this.aVariable = 10
Variable of super-class of the enclosing class super.aVariable = 1
((Original)this).aVariable = 1 = super.aVariable
Method of enclosing class aMethod() = 30
Overridden aMethod unshadowed super.aMethod() = 1

C:\JavaCodeFiles\Basics1\SCObjectOrientation2>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






