/* Any piece of source-code without a package-declaration,causes

 * the compiled byte-code to be run by the Java Runtime Environment as a

 * part of the (so-called) default package!

 *  This is true especially for the classes below: "Extension2" and "ImportingExtension":

 */



import Experimental.Original0;   // needs class Original0 to be declared public

import Experimental.Extension1; // needs class Extension1 to be declared public



class Extension2 extends Extension1

{ Extension2()

  { System.out.println

    (

// "\nfrom OUTSIDE PACKAGE but in sub-class of Extension1 instance: defaul = " + this.defaul +
/* ^ the above produces a compile-time error:

 * defaul is not public in Experimental.Original0; cannot be accessed from outside package

 */

"\nfrom OUTSIDE PACKAGE but in sub-class of Extension1 instance: protecte = " + this.protecte

    );

} }

/*

 * The class below finally contains the main()-method:

 */

class ImportingExtension

{ public static void main( String unused[] )

  { Original0 original = new Original0();

    // this needs constructor Original0() to be declared public

    Extension1 extension1 = new Extension1();

    // this needs constructor Extension1() to be declared public

    System.out.println

    (

// "\nfrom OUTSIDE package Extension1 instance: defaul = " + extension1.defaul +

/* ^ the above produces a compile-time error:

 * defaul is not public in Experimental.Original0; cannot be accessed from outside package

 */

// "\nfrom OUTSIDE package Extension1 instance: protecte = " +  extension1.protecte +

/* ^ the above produces a compile-time error:

 * protecte has protected access in Experimental.Original0

 */

"\nfrom OUTSIDE PACKAGE package Extension1 instance: publi = " + extension1.publi

    );

    //////////////////////////////////////////////////// first class OUTSIDE the package

    Extension2 ext2 = new Extension2();

    System.out.println

    (

// "\nfrom instance of sub-class outside package: defaul = " + ext2.defaul +

/* ^ the above produces a compile-time error:

 *  defaul is not public in Experimental.Original0;

 *  cannot be accessed from outside package

 */

// "\nfrom instance of sub-class outside package: protecte = " +  ext2.protecte +

/* ^ the above produces a compile-time error:

 *  protecte has protected access in Experimental.Original0

 */



"\nfrom instance of sub-class outside package: publi = " + ext2.publi

    );

} }





/* PREREQUISITE: package 'Experimental' is loadable, that means for example:
   PREREQUISITE: JavaCodeFiles/Basics1/SCObjectOrientation2 contains a folder named 'Experimental',
                 which in turn contains the files of source-code Original0.java and Extension1.java
                 (then these files are found and compiled automatically by the single compilation command below!)
                 (As usual, be aware of typing errors!)
   PREREQUISITE: OR the package has been placed into the ext-folder as a compiled and jarred file.
*/
/*
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation2] andreadipietro% javac ImportingExtension.java
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation2] andreadipietro% java ImportingExtension

from Original0 instance: privat = 1

from Original0 instance: privat = 1

from Extension1 instance: defaul = 2
from Extension1 instance: protecte = 3
from Extension1 instance: publi = 4

from OUTSIDE PACKAGE package Extension1 instance: publi = 4

from Original0 instance: privat = 1

from Extension1 instance: defaul = 2
from Extension1 instance: protecte = 3
from Extension1 instance: publi = 4

from OUTSIDE PACKAGE but in sub-class of Extension1 instance: protecte = 3

from instance of sub-class outside package: publi = 4
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation2] andreadipietro%
*/




/*
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation2 > javac ImportingExtension.java
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation2 > java ImportingExtension

from Original0 instance: privat = 1

from Original0 instance: privat = 1

from Extension1 instance: defaul = 2
from Extension1 instance: protecte = 3
from Extension1 instance: publi = 4

from OUTSIDE PACKAGE package Extension1 instance: publi = 4

from Original0 instance: privat = 1

from Extension1 instance: defaul = 2
from Extension1 instance: protecte = 3
from Extension1 instance: publi = 4

from OUTSIDE PACKAGE but in sub-class of Extension1 instance: protecte = 3

from instance of sub-class outside package: publi = 4
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation2 >
*/



/*
C:\JavaCodeFiles\Basics1\SCObjectOrientation2>javac ImportingExtension.java

C:\JavaCodeFiles\Basics1\SCObjectOrientation2>java ImportingExtension

from Original0 instance: privat = 1

from Original0 instance: privat = 1

from Extension1 instance: defaul = 2
from Extension1 instance: protecte = 3
from Extension1 instance: publi = 4

from OUTSIDE PACKAGE package Extension1 instance: publi = 4

from Original0 instance: privat = 1

from Extension1 instance: defaul = 2
from Extension1 instance: protecte = 3
from Extension1 instance: publi = 4

from OUTSIDE PACKAGE but in sub-class of Extension1 instance: protecte = 3

from instance of sub-class outside package: publi = 4

C:\JavaCodeFiles\Basics1\SCObjectOrientation2>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






