class TopLevel    //// ------------ a top-level-class together with nested classes, like:

{

  static void staticMethod( String s )

  { System.out.println( "static method called from " + s ); }

  void instanceMethod( String s )

  { System.out.println( "instance method called from " + s ); }



  static class StaticNested   //// ----- a statically nested class, a static member class

  { StaticNested()

    { System.out.println( "StaticNested class instantiated" );

      staticMethod( "Nested Top Level class" );

  } }



  class NamedInner           //// ------------- a non-static member-class, an inner class

  { NamedInner()

    { System.out.println( "NamedInner class instantiated" );

      TopLevel.this.instanceMethod( "NamedInner class" ); // access to enclosing instance

      TopLevel.staticMethod( "NamedInner class" );

  } }



  public static void main( String unused[] )

  {

    class Local                            //// a local class within a method

    { Local(){ System.out.println( "Local class instantiated" );}

    }

    new StaticNested();                   /// an anonymous object:

                                          /// Useful if only instantiation necessary,

                                          /// and no further reference needed.

    TopLevel theInstance = new TopLevel();

    theInstance.new NamedInner();         /// anonymous member object in theInstance

    new Local();

    staticMethod( "main()-method" );

    theInstance.instanceMethod( "main()-method" );

} }


/*
[localhost:~/JavaCodeFiles/BasicProgrammingI/SCObjectOrientation1] marycosway% javac TopLevel.java
[localhost:~/JavaCodeFiles/BasicProgrammingI/SCObjectOrientation1] marycosway% java TopLevel
StaticNested class instantiated
static method called from Nested Top Level class
NamedInner class instantiated
instance method called from NamedInner class
static method called from NamedInner class
Local class instantiated
static method called from main()-method
instance method called from main()-method
[localhost:~/JavaCodeFiles/BasicProgrammingI/SCObjectOrientation1] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 > javac TopLevel.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 > java TopLevel
StaticNested class instantiated
static method called from Nested Top Level class
NamedInner class instantiated
instance method called from NamedInner class
static method called from NamedInner class
Local class instantiated
static method called from main()-method
instance method called from main()-method
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 >
*/

/*
C:\JavaCodeFiles\Basics1\SCObjectOrientation1>javac TopLevel.java

C:\JavaCodeFiles\Basics1\SCObjectOrientation1>java TopLevel
StaticNested class instantiated
static method called from Nested Top Level class
NamedInner class instantiated
instance method called from NamedInner class
static method called from NamedInner class
Local class instantiated
static method called from main()-method
instance method called from main()-method

C:\JavaCodeFiles\Basics1\SCObjectOrientation1>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






