class SelfLogStaticInstanceFinalize         // class-definition

{

  static{ System.out.println("Class loaded"); }                  // static-initializer

  { System.out.println("Class instantiated = object created"); } // instance-initializer

  public void finalize(){ System.out.println("object erased"); } // finalize()-method

}



public class SelfLog

{ public static void main( String unused[] )

  {

    SelfLogStaticInstanceFinalize x;                             // class declaration

    System.out.println( "object declared" );

    try{Class.forName("SelfLogStaticInstanceFinalize");}         // explicit class loading

    catch(java.lang.ClassNotFoundException e){ e.printStackTrace();}

    x = new SelfLogStaticInstanceFinalize();                     // class allocation/instantiation

    x = null; System.gc();

   // above, preparing to erase the object from the computer's Random Access Memory

   // for(int i = 0; i < 1000; i++){ int q=i^2; }

   // waiting for the object to vanish, unnecessary with some OS's

} }

/*

--- The instantiation loads the class automatically into the current Java Runtime Environment.

    Nevertheless has been shown how to explicitly load a class without instantiating it.

    Comment out the try, catch and new lines to see that declaring an identifier does not load the class.

--- Here has been used the default constructor which is furnished for every class.

--- Waiting for destruction is usually necessary,

    because the program and the Java Runtime Environment might terminate faster

    than the destruction can be reported.

*/



/*
[localhost:~/JavaCodeFiles/BasicProgrammingI/SCObjectOrientation1] marycosway% javac SelfLog.java
[localhost:~/JavaCodeFiles/BasicProgrammingI/SCObjectOrientation1] marycosway% java SelfLog
object declared
Class loaded
Class instantiated = object created
object erased
[localhost:~/JavaCodeFiles/BasicProgrammingI/SCObjectOrientation1] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 > javac SelfLog.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 > java SelfLog
object declared
Class loaded
Class instantiated = object created
object erased
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 >
*/

/*
C:\JavaCodeFiles\Basics1\SCObjectOrientation1>javac SelfLog.java

C:\JavaCodeFiles\Basics1\SCObjectOrientation1>java SelfLog
object declared
Class loaded
Class instantiated = object created
object erased

C:\JavaCodeFiles\Basics1\SCObjectOrientation1>
*/



/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






