/* demonstration of anonymous objects and anonymous classes */

class NamedClass

{ NamedClass(){ System.out.println( "Constructor-call" ); }

  public static void main( String unused[] )

  {

    // anonymous OBJECT, derived from a named class:

    new NamedClass();



    // anonymous CLASS, because it extends the named class with additional code,

    // instantiates an anonymous object of its type

    // (the following is an allocation expression with non-trivial class-body)

    new NamedClass()

    {

      { // instance-initializer can supplement the role of default constructor

        System.out.println( "a truly anonymous class instantiated" );

      }

    };

    System.out.println( new String( "finally an anonymous String-object" ) );

} }

/*

--- Two constructor-calls are seen below,

    because two anonymous objects are instantiated with the same constructor.

--- The second time the named class is extended by the code making it truly anonymous.

*/



/*
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation1] marycosway% javac NamedClass.java
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation1] marycosway% java NamedClass
Constructor-call
Constructor-call
a truly anonymous class instantiated!
finally an anonymous String-object
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation1] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 > javac NamedClass.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 > java NamedClass
Constructor-call
Constructor-call
a truly anonymous class instantiated
finally an anonymous String-object
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 >
*/

/*
C:\JavaCodeFiles\Basics1\SCObjectOrientation1>javac NamedClass.java

C:\JavaCodeFiles\Basics1\SCObjectOrientation1>java NamedClass
Constructor-call
Constructor-call
a truly anonymous class instantiated
finally an anonymous String-object

C:\JavaCodeFiles\Basics1\SCObjectOrientation1>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






