/*- The following class stores the number of its instantiations (staticCounter)

    and labels each object with a number (objectNumber).

--- This is done with static and non-static member-variables.

--- The associated code can be found in a static- and a non-static initializer.

--- The output can be done choosing between static or non-static member-methods.

*/

class TheClass

{

  static int staticCounter;                                        // class-variable

  static void staticOut( String s, int n )

  { System.out.println( s + " staticOut: " + n ); }



  int objectNumber;                                               // instance-variable

  void instanceOut( String s, int i ){ System.out.println( s + " instanceOut: " + i ); }



  static{ staticCounter = 0;}                                    // static-initializer

  { staticCounter ++; objectNumber = staticCounter; }           // instance-initializer

}

public class Access

{ public static void main( String unused[] )

  { TheClass obj1,obj2;

    obj1 = new TheClass();

    obj2 = new TheClass();

    TheClass.staticOut( "Number of objects ", TheClass.staticCounter );

    obj1.instanceOut( "no. of obj1: ", obj1.objectNumber );

    TheClass.staticOut( "no. of obj2: ", obj2.objectNumber );   // read access

    obj2.objectNumber = 5;                                     // write access

    obj2.instanceOut( "Test, write access: ", obj2.objectNumber );

} }



/* 
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation1] marycosway% javac Access.java
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation1] marycosway% java Access
Number of objects  staticOut: 2
no. of obj1:  instanceOut: 1
no. of obj2:  staticOut: 2
Test, write access:  instanceOut: 5
[localhost:~/JavaCodeFiles/Basics1/SCObjectOrientation1] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 > javac Access.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 > java Access
Number of objects  staticOut: 2
no. of obj1:  instanceOut: 1
no. of obj2:  staticOut: 2
Test, write access:  instanceOut: 5
marycosway@linux:~/JavaCodeFiles/Basics1/SCObjectOrientation1 >
*/

/*
C:\JavaCodeFiles\Basics1\SCObjectOrientation1>javac Access.java

C:\JavaCodeFiles\Basics1\SCObjectOrientation1>java Access
Number of objects  staticOut: 2
no. of obj1:  instanceOut: 1
no. of obj2:  staticOut: 2
Test, write access:  instanceOut: 5

C:\JavaCodeFiles\Basics1\SCObjectOrientation1>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






