/* Thread class-extension: conceptually clean,<ProgExtendThread>

   but problematic if an already derived class is to become threadable

   (for those cases omit this example and consider the next ones!)

*/

class ThreadWithRun extends Thread

{ int i;

  ThreadWithRun( int i )

  { //super(); // unnecessary because implicitly called.

    this.i = i;

    this.start();

  }

  public void run()

  {

    for( int n = 0; n < 4; n++ )

    { System.out.println( "thread no." + i + " active" );

      //try{ Thread.sleep( 10 ); }catch( InterruptedException e ){ System.exit( 0 ); }

           // sleeping may be seen as a faint emulation of time-slicing

      //Thread.yield();

      // above, Mac OS no difference, Linux, main thread ends after both threads ended

      //this.interrupt();

      // above, Mac OS no difference may act like a premature System.exit( 0 ),

      // above, Linux no difference

} } }

public class ThreadExtension

{ public static void main( String unused[] )

  { new ThreadWithRun( 1 );                     // anonymous or

    ThreadWithRun X = new ThreadWithRun( 2 );   // with unused identifier

    System.out.println( Thread.currentThread() + " main()-thread ends." );

} }



/*

--- this.start() could be omitted from the constructor; but then

    the threads have to be started in the main()-method, for example like this:

    X.start(); or new ThreadWithRun(1).start();

--- Observe that the sequence of statements in the main()-method isn't reflected

    in the sequence of the output.

*/






/*
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% javac ThreadExtension.java
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% java ThreadExtension
thread no.1 active
thread no.2 active
thread no.1 active
thread no.2 active
Thread[main,5,main] main()-thread ends.
thread no.1 active
thread no.2 active
thread no.1 active
thread no.2 active
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro%
*/

/*
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > javac ThreadExtension.java
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > java ThreadExtension
thread no.1 active
thread no.1 active
thread no.1 active
thread no.1 active
thread no.2 active
thread no.2 active
thread no.2 active
thread no.2 active
Thread[main,5,main] main()-thread ends.
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading >
*/

/*
C:\JavaCodeFiles\Basics1\SCMultithreading>javac ThreadExtension.java

C:\JavaCodeFiles\Basics1\SCMultithreading>java ThreadExtension
thread no.1 active
thread no.1 active
thread no.1 active
thread no.2 active
Thread[main,5,main] main()-thread ends.
thread no.1 active
thread no.2 active
thread no.2 active
thread no.2 active

C:\JavaCodeFiles\Basics1\SCMultithreading>
*/

/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






