/* Here the constructor of the thread contains an object,

   this object is an on-the-spot anonymous implementation

   of the Runnable interface.

*/

public class ThreadAnonRunnable

{

  public static void method( String s )

  {

    for( int i = 0; i < 4; i++ )

    { System.out.println( s );

      Thread.yield(); // Mac OS, Linux no difference

      //Thread.currentThread().interrupt(); // Mac OS, Linux almost the same as above

      //try{ Thread.sleep( 10 ); }catch( InterruptedException e ){e.printStackTrace();}

      // above, a sort of time-slicing effect

  } }

  public static void main( String unused[] )

  {                                         //------------------ two anonymous threads:

    new Thread

    (  new Runnable()

       { public void run(){ method( "thread no.1 active" ); }

       }

    ).start();

    new Thread( new Runnable()

                    { public void run(){ method( "thread no.2 active" ); } } ).start();

    System.out.println( Thread.currentThread() + " main()-thread ends." );

} }

// Observe that the sequence of statements in the main class isn't reflected

// in the sequence of the output




/*
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% javac ThreadAnonRunnable.java
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% java ThreadAnonRunnable
thread no.1 active
thread no.1 active
thread no.1 active
thread no.1 active
thread no.2 active
Thread[main,5,main] main()-thread ends.
thread no.2 active
thread no.2 active
thread no.2 active
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro%
*/

/*
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > javac ThreadAnonRunnable.java
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > java ThreadAnonRunnable
thread no.1 active
thread no.1 active
thread no.1 active
thread no.1 active
Thread[main,5,main] main()-thread ends.
thread no.2 active
thread no.2 active
thread no.2 active
thread no.2 active
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading >
*/

/*
C:\JavaCodeFiles\Basics1\SCMultithreading>javac ThreadAnonRunnable.java

C:\JavaCodeFiles\Basics1\SCMultithreading>java ThreadAnonRunnable
Thread[main,5,main] main()-thread ends.
thread no.1 active
thread no.2 active
thread no.1 active
thread no.2 active
thread no.1 active
thread no.2 active
thread no.1 active
thread no.2 active

C:\JavaCodeFiles\Basics1\SCMultithreading>
*/

/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






