/*

The central object is given by an instance of class-type java.util.Vector

This object is accessed from the run()-method of a Thread-object "Together"

adding two strings to the vector, both either synchronized or unsynchronized.

But the Vector-object also is accessed from a run()-method of a Thread-object "Disturb",

adding a string of "plus"-signs.

Randomizing sleeping-times and looping ten times, to reproduce different settings,

gives the output as printed below.

*/



import java.util.* ; // contains the predefined Vector class

class Together extends Thread

{

  java.util.Vector object;

  Together( Vector arg ){ object = arg; this.start(); }               // constructor

  void to( Vector arg ){ arg.addElement( "to" ); }

                      // java.util.Vector.addElement() already has been synchronized!

  void gether( Vector arg ){ arg.addElement( "gether" ); }

  //

  // Now two alternative run()-methods: One with UNSYNCHRONIZED access:

  /* public void run()

     { sleeps( 30 ); to( object ); sleeps( 30 ); gether( object ); }

  */

  // OR the other run()-method below with SYNCHRONIZED access:

  public void run()

  { sleeps( 30 );

    synchronized( object ){ to( object ); sleeps( 30 ); gether( object ); }

  }

  //

  void sleeps(int s)

  { try{ this.sleep( (int)( s*java.lang.Math.random() ) ); }

    catch( InterruptedException e ){ e.printStackTrace(); }

} }

class Disturb extends Thread

{

  java.util.Vector object;

  Disturb( Vector arg ){ object = arg; this.start(); }

  void enterPluses( Vector arg ){ arg.addElement( "++++" ); }

  public void run(){ sleeps( 1 ); enterPluses( object ); }

  void sleeps( int s )

  { try{ this.sleep( (int)( s*java.lang.Math.random() ) );}

    catch( InterruptedException e ){ e.printStackTrace(); }

} }

public class Synchrobject

{ public static void main( String unused[] )

  {

    for( int i = 0; i < 10; i++ )

    { Vector object = new Vector();

      Together thread1 = new Together( object );

      Disturb thread2 = new Disturb( object );

      try{ thread1.join(); thread2.join(); }

      catch( InterruptedException e ){ e.printStackTrace(); }

      System.out.println( object.toString() ); // OUTPUT

} } }

/* output: UNSYNCHRONIZED
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% javac Synchrobject.java
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% java Synchrobject
[++++, to, gether]
[++++, to, gether]
[to, ++++, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro%
output: SYNCHRONIZED
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% javac Synchrobject.java
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% java Synchrobject
[++++, to, gether]
[++++, to, gether]
[to, gether, ++++]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro%
*/


/* output: SYNCHRONIZED
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > javac Synchrobject.java
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > java Synchrobject
[++++, to, gether]
[to, gether, ++++]
[to, gether, ++++]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[to, gether, ++++]
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading >

output: UNSYNCHRONIZED
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > javac Synchrobject.java
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > java Synchrobject
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[to, ++++, gether]
[++++, to, gether]
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading >
*/


/* output: SYCHRONIZED
C:\JavaCodeFiles\Basics1\SCMultithreading>javac Synchrobject.java

C:\JavaCodeFiles\Basics1\SCMultithreading>java Synchrobject
[++++, to, gether]
[++++, to, gether]
[to, gether, ++++]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]

C:\JavaCodeFiles\Basics1\SCMultithreading>


output: UNSYCHRONIZED
C:\JavaCodeFiles\Basics1\SCMultithreading>javac Synchrobject.java

C:\JavaCodeFiles\Basics1\SCMultithreading>java Synchrobject
[to, ++++, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]
[++++, to, gether]

C:\JavaCodeFiles\Basics1\SCMultithreading>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






