/*

  Two Thread-objects of type ThreadWithPriority are created.

  They are created with differing priorities.

  The thread which finishes first terminates the run of both.

*/

// the threads communicate using an instance of this class

final class Sign{ public boolean sign; }



class ThreadWithPriority extends Thread

{

  int p; Sign halt;

  ThreadWithPriority( int p, Sign halt )

  { super(); this.p = p; this.setPriority(p); this.halt = halt; this.start();

  }

  public void run()

  { for( int i = 1; i <= 10; i++ )

    {

      if( halt.sign == true)

      { System.out.println( "total halt by thread of priority " + this.getPriority() );

        System.exit( 0 );

      }

      System.out.println( i + " Thread with priority " + this.getPriority() );

      Thread.yield(); // yielding in Mac OS

      //this.interrupt();       // works like yield() in Mac OS

      /*try{ Thread.sleep( 10 ); }

        catch( InterruptedException e ){ System.out.println("interrupted"); }*/

      // sleep does not respect priorities and has a time-slicing effect

    }

    halt.sign = true;

    System.out.println( "Thread with priority " + this.getPriority() + " ended." );

    // System.exit( 0 ); // termination without communication

} }



public class Starve

{

  public static void main( String delayInMilliSec[] )

  {

    Thread.currentThread().setPriority( Thread.MAX_PRIORITY );

    System.out.println

       ( "Priority of main()-thread is " + Thread.currentThread().getPriority() );

    Sign halt = new Sign(); // same result as being a static member of Starve

    System.out.println( "Thread with low priority starts: ");

    new ThreadWithPriority( Thread.MIN_PRIORITY, halt );

    try{ Thread.sleep( Integer.parseInt( delayInMilliSec[0] ) ); }

    catch( Exception e ){ e.printStackTrace(); };

    System.out.println( "Thread with higher priority starts: ");

    new ThreadWithPriority( Thread.NORM_PRIORITY-1, halt ); // the bully

} }






/*
(may depend on platform and chosen stream(java Starve or java Starve>>>Starve.java))
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% javac Starve.java
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% java Starve 50
Priority of main()-thread is 10
Thread with norm priority starts: 
1 Thread with priority 1
2 Thread with priority 1
Thread with higher priority is starts: 
1 Thread with priority 4
2 Thread with priority 4
3 Thread with priority 4
4 Thread with priority 4
5 Thread with priority 4
6 Thread with priority 4
7 Thread with priority 4
8 Thread with priority 4
9 Thread with priority 4
10 Thread with priority 4
Thread with priority 4 ended.
total halt by thread of priority 1
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro%
*/

/*
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > javac Starve.java
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > java Starve 50
Priority of main()-thread is 10
Thread with norm priority starts:
1 Thread with priority 1
2 Thread with priority 1
3 Thread with priority 1
4 Thread with priority 1
5 Thread with priority 1
6 Thread with priority 1
7 Thread with priority 1
8 Thread with priority 1
9 Thread with priority 1
10 Thread with priority 1
Thread with priority 1 ended.
Thread with higher priority is starts:
total halt by thread of priority 4
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading >
*/

/*
C:\JavaCodeFiles\Basics1\SCMultithreading>javac Starve.java

C:\JavaCodeFiles\Basics1\SCMultithreading>java Starve 25
Priority of main()-thread is 10
Thread with norm priority starts:
1 Thread with priority 1
2 Thread with priority 1
3 Thread with priority 1
Thread with higher priority is starts:
1 Thread with priority 4
2 Thread with priority 4
4 Thread with priority 1
3 Thread with priority 4
4 Thread with priority 4
5 Thread with priority 4
6 Thread with priority 4
5 Thread with priority 1
7 Thread with priority 4
6 Thread with priority 1
8 Thread with priority 4
9 Thread with priority 4
7 Thread with priority 1
10 Thread with priority 4
Thread with priority 4 ended.
total halt by thread of priority 1

C:\JavaCodeFiles\Basics1\SCMultithreading>
*/

/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */







