/*- Two threads with a loop run concurrently in producing terminal output:

--- An interwoven output approximating (12121212121212121212)

    indicates that the platform furnishes time-slicing or multiprocessing.

--- A sequential output approximating (11111111112222222222)

    indicates that the platform leaves part of the scheduling to the Java programmer;

    for example in the form of calling yield()- or interrupt()- or sleep()-methods,

    which have been outcommented below.

*/

class TheThread extends java.lang.Thread

{ int i;

  TheThread(int i)

  { //super(); // not needed, because implicitly called!

    this.i = i;

    System.out.println( "Thread no." + i + " starts:" );

    this.start();

  }

  public void run()

  {

    for( int c = 1; c <= 10; c++ )

    {

      System.out.println( "Thread no." + i + " step " + c );

      //try{ Thread.sleep(1);}catch( InterruptedException e ){ System.exit( 0 );}

      //this.interrupt(); // Mac OS, Linux no difference

      //this.yield();  // Mac OS, Linux no essential difference

} } }

public class SchedulingOfJavaPlatform

{ public static void main( String unused[] )

  { new TheThread(1); new TheThread(2);

} }






/*
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] marycosway% javac SchedulingOfJavaPlatform.java
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] marycosway% java SchedulingOfJavaPlatform
Thread no.1 starts:
Thread no.1 step 1
Thread no.2 starts:
Thread no.1 step 2
Thread no.1 step 3
Thread no.1 step 4
Thread no.1 step 5
Thread no.1 step 6
Thread no.1 step 7
Thread no.1 step 8
Thread no.1 step 9
Thread no.1 step 10
Thread no.2 step 1
Thread no.2 step 2
Thread no.2 step 3
Thread no.2 step 4
Thread no.2 step 5
Thread no.2 step 6
Thread no.2 step 7
Thread no.2 step 8
Thread no.2 step 9
Thread no.2 step 10
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/Basics1/SCMultithreading > javac SchedulingOfJavaPlatform.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCMultithreading > java SchedulingOfJavaPlatform
Thread no.1 starts:
Thread no.1 step 1
Thread no.1 step 2
Thread no.1 step 3
Thread no.1 step 4
Thread no.1 step 5
Thread no.1 step 6
Thread no.1 step 7
Thread no.1 step 8
Thread no.1 step 9
Thread no.1 step 10
Thread no.2 starts:
Thread no.2 step 1
Thread no.2 step 2
Thread no.2 step 3
Thread no.2 step 4
Thread no.2 step 5
Thread no.2 step 6
Thread no.2 step 7
Thread no.2 step 8
Thread no.2 step 9
Thread no.2 step 10
marycosway@linux:~/JavaCodeFiles/Basics1/SCMultithreading >
*/

/*
C:\JavaCodeFiles\Basics1\SCMultithreading>javac SchedulingOfJavaPlatform.java

C:\JavaCodeFiles\Basics1\SCMultithreading>java SchedulingOfJavaPlatform
Thread no.1 starts:
Thread no.2 starts:
Thread no.2 step 1
Thread no.1 step 1
Thread no.2 step 2
Thread no.1 step 2
Thread no.2 step 3
Thread no.1 step 3
Thread no.2 step 4
Thread no.2 step 5
Thread no.1 step 4
Thread no.2 step 6
Thread no.1 step 5
Thread no.2 step 7
Thread no.1 step 6
Thread no.2 step 8
Thread no.1 step 7
Thread no.2 step 9
Thread no.1 step 8
Thread no.2 step 10
Thread no.1 step 9
Thread no.1 step 10

C:\JavaCodeFiles\Basics1\SCMultithreading>
*/

/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






