/* First there is given an object of type VarInteger.

   This wraps an integer-value that can be

   changed with a set()- and retrieved with the get()-method.



   Then two threads are at work:

-- The main()-thread tries to decrement the value as much as possible.

-- A Service thread tries to increment the value four times EXCLUSIVELY.



  To deny access to the main-thread, the Service thread synchronizes the

  adding-code and the object of class-type VarInteger.

  The process of incrementing works exclusively only

  if the get()-method has been synchronized too.

*/

class VarInteger

{ int i; VarInteger( int x ){ i = x; };

  public void set( int i ){ this.i = i; }

  //public synchronized int get(){ return i; }

  // the line above keeps atomicity exclusive, SYNCHRONIZED or the line below:

  public int get(){ return i; } // breaks atomicity

}

/* Primitive-Type Object-Wrappers like Integer, Boolean, ...

   let their values remain fixed, the class above allows changing the value */



class Service extends Thread

{ VarInteger count; int millis;

  Service( int milliSeconds, VarInteger count )

  { this.count = count; millis = milliSeconds;

    this.start();

  }

  public void run()

  { synchronized( count )

    { for( int i = 0; i < 4; i++ )

      { count.set( count.get() + 1 );

        System.out.println( count.get() );

        try{ sleep( millis ); }catch( InterruptedException e ){ e.printStackTrace(); };

        // Thread.yield(); // sleep(0)=yield()

} } } }



public class Race

{ public static void main( String unused[] )

  {

    VarInteger counter = new VarInteger(0);

    Service adder = new Service( 100, counter );

    while( adder.isAlive() )

    { counter.set( counter.get() - 1 );

      Thread.yield(); // enforces thread change if no time-slicing done

    }

    System.out.println("adder not alive");

} }

// The main()-method outraces the adder-thread if the adder-thread sleeps too much.

// The 'set()'-method above should be synchronized too.






/*
 (output with synchronized VarInteger.get() method: SYNCHRONIZED)
(ideally the VarInteger.set() method should be synchronized too):
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] marycosway% javac Race.java
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] marycosway% java Race
1
2
3
4
adder not alive
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] marycosway%

(output if VarInteger.get() method is not synchronized)
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] marycosway% javac Race.java
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] marycosway% java Race
1
-34
-81
-133
adder not alive
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] marycosway%
*/



/*
(output with synchronized VarInteger.get() method, SYNCHRONIZED
  with Linux the first run after compilation may have been shifted by -1496)
marycosway@linux:~/JavaCodeFiles/Basics1/SCMultithreading >
marycosway@linux:~/JavaCodeFiles/Basics1/SCMultithreading > java Race
1
2
3
4
adder not alive
marycosway@linux:~/JavaCodeFiles/Basics1/SCMultithreading >

(output if VarInteger.get() method is not synchronized)
marycosway@linux:~/JavaCodeFiles/Basics1/SCMultithreading > javac Race.java
marycosway@linux:~/JavaCodeFiles/Basics1/SCMultithreading > java Race
1
-13996
-42037
-66804
adder not alive
marycosway@linux:~/JavaCodeFiles/Basics1/SCMultithreading >
*/



/*
(output with synchronized VarInteger.get() method: SYNCHRONIZED)
C:\JavaCodeFiles\Basics1\SCMultithreading>javac Race.java

C:\JavaCodeFiles\Basics1\SCMultithreading>java Race
0
1
2
3
adder not alive

C:\JavaCodeFiles\Basics1\SCMultithreading>


(output if VarInteger.get() method is not synchronized)
C:\JavaCodeFiles\Basics1\SCMultithreading>javac Race.java

C:\JavaCodeFiles\Basics1\SCMultithreading>java Race
0
-12418
-27344
-46192
adder not alive

C:\JavaCodeFiles\Basics1\SCMultithreading>
*/

/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






