/* Two objects of type ThreadLife are acquainted.

   One finishes only if the other has finished.

*/

class ThreadLife extends Thread

{ Thread t; int n;

  ThreadLife( int n ){ this.n = n; }

  public void acquaintWith( Thread t ){ this.t = t; };

  public void run()

  { try{ Thread.sleep( 5 ); }catch( Exception e ){ e.printStackTrace(); }

    while( true )

    { System.out.println( "thread " + n + " alive, waiting for the other to finish");

      //try{ t.join(); }catch(InterruptedException e){}  // makes another deadlock

      if( !t.isAlive() ){ System.exit( 0 ); }           // this makes the lifelock

      yield(); // works well with Mac OS, Linux; unnecessary with Windows!

} } }



public class MiniLifelock

{ public static void main( String unused[] )

  { ThreadLife a,b;

    a = new ThreadLife(1); b = new ThreadLife(2);

    a.acquaintWith(b); b.acquaintWith(a);

    System.out.println( "before start " + a.isAlive() + " " + b.isAlive() );

    a.start(); b.start();

    System.out.println( "main()-method-call ended" );

} }

/* None of the threads stops running because both are waiting to be notified.

   Thus the terminal from were the code has been run, continously prints messages.

*/





/*
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% javac MiniLifelock.java
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% java MiniLifelock
before start false false
main()-method-call ended
thread 1 alive, waiting for the other to finish
thread 2 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 2 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 2 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
....
^C (CTRL-C)
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro%
*/

/*
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > javac MiniLifelock.java
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > java MiniLifelock
before start false false
main()-method-call ended
thread 1 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
...
thread 2 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 2 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 2 alive, waiting for the other to finish
...
(CTRL-C)
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading >
*/

/*
C:\JavaCodeFiles\Basics1\SCMultithreading > javac MiniLifelock.java

C:\JavaCodeFiles\Basics1\SCMultithreading > java MiniLifelock
before start false false
main()-method-call ended
thread 2 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 2 alive, waiting for the other to finish
thread 1 alive, waiting for the other to finish
thread 2 alive, waiting for the other to finish
...
(CTRL-C)
C:\JavaCodeFiles\Basics1\SCMultithreading >
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */







